Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Signatures.DecSetoidPropRecord.

Section tfProp.
   Variable T : Transform.
   Notation "'of' P" := (option (P T)) (at level 0).

   Record tfProp :=
      {
         tf_dsprop                            :> dsProp T;
         tf_fndsprop                          : dsProp (fn T);
         cancelative                          : of Cancelative;
         cancelative_comp                     : of Cancelative_comp;
         condensed                            : of Condensed;
         condensed_comp                       : of Condensed_comp
      }.
End tfProp.

   Definition tfPropIso : forall {T T'} (I : TfIso T T'), tfProp T -> tfProp T'.
      intros T T' I tfp; apply (Build_tfProp _ 
                                 (dsPropIso I tfp) 
                                 (dsPropIso (fnIso I) (tf_fndsprop _ tfp))); 
      destruct tfp.
      apply (opfn (Iso_Cancelative I)); trivial.
      apply (opfn (Iso_Cancelative_comp I)); trivial.
      apply (opfn (Iso_Condensed I)); trivial.
      apply (opfn (Iso_Condensed_comp I)); trivial.
   Defined.