Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Export Metarouting.Signatures.SemigroupPropRecord.
Require Export Metarouting.Signatures.TransformPropRecord.

Section stProp.
   Variable ST : SemigroupTransform.
   Notation "'of' P" := (option (P ST)) (at level 0).

   Record stProp :=
   {
      st_sgprop                            :> sgProp ST;
      st_tfprop                            :> tfProp ST;
      distributive                         : of Distributive;
      distributive_comp                    : of Distributive_comp;
      inflationary                         : of Inflationary;
      inflationary_comp                    : of Inflationary_comp;
      strictInflationary                   : of StrictInflationary;
      strictInflationary_comp              : of StrictInflationary_comp;
      strict                               : of Strict;
      strict_comp                          : of Strict_comp
   }.
End stProp.


   Definition stPropIso : forall {S S'} (I : STfIso S S'), stProp S -> stProp S'.
      intros S S' I stp; apply (Build_stProp _ (sgPropIso I stp) (tfPropIso I stp)); destruct stp.
      apply (opfn (Iso_Distributive I)); trivial.
      apply (opfn (Iso_Distributive_comp I)); trivial.
      (* CommIdem *)
      apply (opfn (Iso_Inflationary I)); trivial.
      apply (opfn (Iso_Inflationary_comp I)); trivial.
      apply (opfn (Iso_StrictInflationary I)); trivial.
      apply (opfn (Iso_StrictInflationary_comp I)); trivial.
      (* HasIdentity *)
      apply (opfn (Iso_Strict I)); trivial.
      apply (opfn (Iso_Strict_comp I)); trivial.
   Defined.