Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Export Metarouting.Signatures.SemigroupProperties.
Require Export Metarouting.Signatures.DecSetoidPropRecord.

Section sgProp.
   Variable S : Semigroup.
   Notation "'of' P" := (option (P S)) (at level 0).

   Record sgProp :=
   {
      sg_dsprop             :> dsProp S;
      hasIdentity           : of HasIdentity;
      hasIdentity_comp      : of HasIdentity_comp;
      hasAnnihilator        : of HasAnnihilator;
      hasAnnihilator_comp   : of HasAnnihilator_comp;
      isSelective           : of IsSelective;
      isSelective_comp      : of IsSelective_comp;
      isCommutative         : of IsCommutative;
      isCommutative_comp    : of IsCommutative_comp;
      isIdempotent          : of IsIdempotent;
      isIdempotent_comp     : of IsIdempotent_comp;
      isLeft                : of IsLeft;
      isLeft_comp           : of IsLeft_comp;
      isRight               : of IsRight;
      isRight_comp          : of IsRight_comp;
      leftCondensed         : of LeftCondensed;
      leftCondensed_comp    : of LeftCondensed_comp;
      rightCondensed        : of RightCondensed;
      rightCondensed_comp   : of RightCondensed_comp;
      leftCancelative       : of LeftCancelative;
      leftCancelative_comp  : of LeftCancelative_comp;
      rightCancelative      : of RightCancelative;
      rightCancelative_comp : of RightCancelative_comp;
      antiLeft              : of AntiLeft;
      antiLeft_comp         : of AntiLeft_comp;
      antiRight             : of AntiRight;
      antiRight_comp        : of AntiRight_comp;
      treeGlb               : of TreeGlb;
      treeGlb_comp          : of TreeGlb_comp
   }.
End sgProp.

   Definition sgPropIso : forall {S S'} (I : SmgIso S S'), sgProp S -> sgProp S'.
      intros S S' I sgp; apply (Build_sgProp _ (dsPropIso I sgp)); destruct sgp.
      apply (opfn (Iso_HasIdentity I)); trivial.
      apply (opfn (Iso_HasIdentity_comp I)); trivial.
      apply (opfn (Iso_HasAnnihilator I)); trivial.
      apply (opfn (Iso_HasAnnihilator_comp I)); trivial.
      apply (opfn (Iso_IsSelective I)); trivial.
      apply (opfn (Iso_IsSelective_comp I)); trivial.
      apply (opfn (Iso_IsCommutative I)); trivial.
      apply (opfn (Iso_IsCommutative_comp I)); trivial.
      apply (opfn (Iso_IsIdempotent I)); trivial.
      apply (opfn (Iso_IsIdempotent_comp I)); trivial.
      apply (opfn (Iso_IsLeft I)); trivial.
      apply (opfn (Iso_IsLeft_comp I)); trivial.
      apply (opfn (Iso_IsRight I)); trivial.
      apply (opfn (Iso_IsRight_comp I)); trivial.
      apply (opfn (Iso_LeftCondensed I)); trivial.
      apply (opfn (Iso_LeftCondensed_comp I)); trivial.
      apply (opfn (Iso_RightCondensed I)); trivial.
      apply (opfn (Iso_RightCondensed_comp I)); trivial.
      apply (opfn (Iso_LeftCancelative I)); trivial.
      apply (opfn (Iso_LeftCancelative_comp I)); trivial.
      apply (opfn (Iso_RightCancelative I)); trivial.
      apply (opfn (Iso_RightCancelative_comp I)); trivial.
      apply (opfn (Iso_AntiLeft I)); trivial.
      apply (opfn (Iso_AntiLeft_comp I)); trivial.
      apply (opfn (Iso_AntiRight I)); trivial.
      apply (opfn (Iso_AntiRight_comp I)); trivial.
      apply (opfn (Iso_TreeGlb I)); trivial.
      apply (opfn (Iso_TreeGlb_comp I)); trivial.
   Defined.