Require Export Metarouting.Logic.Logic.
Require Export Metarouting.Signatures.Semigroup.
Require Export Metarouting.Signatures.DecSetoid.
Require Export Metarouting.Signatures.SemigroupProperties.

(*********************************************************************)
(* defines a natural order for a operation of decidable semigroup *)

(* this is only needed for Lex.v - fix this then Lex needs to be fixed *)
(*
Section NatOrder.
   
   Open Scope Semigroup_scope.

   Variable S : Semigroup.   

   (* x <= y *)
   Definition nat_le (x y : S) :=
      x + y == x.

   (* not (x <= y) *)
   Definition not_nat_le (x y : S) := 
      Not (nat_le x y).

   Notation "A <= B" := (nat_le A B) (at level 70, no associativity) : type_scope.
   (* Notation "A < B" := (Coq.Init.Logic.and (nat_le A B) /\ Not ((nat_le B A))) (at level 70, no associativity) : type_scope. *)
   Notation "A < B" := (Coq.Init.Logic.and (nat_le A B) (Not ((nat_le B A)))) (at level 70, no associativity) : type_scope.

   Lemma le_trans : Transitive S nat_le.
   Proof.
     red.
     intros x y z H H0.
     unfold nat_le in *.
     assert (x + (y + z) == x) as h.
        sg_rewrite S H0. trivial.
     sg_assoc S in h.
     sg_rewrite S H in h.
     trivial.
   Defined.

   Lemma le_dec : Decidable S nat_le.
   Proof.
      red.
      intuition.
      unfold nat_le.
      apply (isDec S).
   Defined.     

   (************************************************************************)
   
   (* useful tactics for simplification *)
   Ltac eq_trans h1 h2 :=
      match type of h1 with (?x == ?y) =>
      match type of h2 with  _ == ?z =>
                  assert (x == z);
                  [ apply (trans _ _ (isEquivalence S) _ _ _ h1 h2) |]
      end
      end.

   Ltac eq_sym h1 := 
      match type of h1 with ?x == ?y =>
            assert (y == x);
            [apply (sym _ _ (isEquivalence S) _ _ h1) | ]
      end.

   (* lemmas for associativity of lex *)

   Lemma equiv_is_eq : forall (x y : S), IsCommutative S -> x <= y -> y <= x -> x == y.
   Proof.
      intros x y H H0 H1.
      unfold nat_le in *.
      assert (x + y == y + x) as h.
         apply H.
      sg_rewrite S H0 in h;
      sg_rewrite S H1 in h;
      trivial.
   Defined.

   Lemma idem_x_plus_y_le_y : forall (x y : S), IsIdempotent S -> x + y <= y.
   Proof.
      intros x y H.
      unfold nat_le.
      red in H.
      assert (y + y == y) as H0.
      trivial.
      assert (x + (y + y) == x + y) as H1.
         sg_rewrite S H0; sg_trivial S.
      sg_assoc S in H1; trivial.
   Defined.

   Lemma idem_x_le_x : forall (x : S), IsIdempotent S -> x <= x.
   Proof.
      intros x H.
      red in H.
      unfold nat_le in *.
      trivial.
   Defined.

   Lemma comm_idem_x_plus_y_le_x : forall (x y : S), IsCommutative S -> IsIdempotent S -> x + y <= x.
   Proof.
     intros x y H H0.
     red in H, H0.
     unfold nat_le in *.
     sg_rewrite S <- (H y x).
     assert (y + x + x == y + (x + x)) as a.
        sg_assoc S; sg_trivial S.
     sg_rewrite S a; sg_rewrite S (H0 x); sg_trivial S.
   Defined.

   Lemma idem_x_le_y_x_le_x_plus_y : forall (x y : S), IsIdempotent S -> x <= y -> x <= x + y.
   Proof.
      intuition; unfold nat_le in *; rewrite H0, (H x); setoid_reflexivity.
   Defined.

   Lemma idem_y_le_x_y_le_x_plus_y : forall (x y : S), IsIdempotent S -> y <= x -> y <= x + y.
   Proof.
      intros x y H H0.
      unfold nat_le in *.
      sg_assoc S.
      sg_rewrite S H0.
      apply H.
   Defined.

   Lemma y_le_x_x_plus_y_le_x : forall (x y : S), y <= x -> x + y <= x.
   Proof.
      intros x y e.
      unfold nat_le in *.
      assert (x + y + x == x + (y + x)) as h.
         sg_assoc S; sg_trivial S.
      sg_rewrite S h; sg_rewrite S e; sg_trivial S.
   Defined.
      
   Lemma x_le_y_x_le_z_x_le_y_plus_z : forall (x y z : S), x <= y -> x <= z -> x <= y + z.
   Proof.
      intros x y z e w.
      unfold nat_le in *.
      sg_assoc S; sg_rewrite S e; sg_rewrite S w; sg_trivial S.
   Defined.

   Lemma z_le_y_z_le_x_z_le_x_plus_y : forall (x y z : S), z <= y -> z <= x -> z <= x + y.
   Proof.
      intros x y z e w.
      unfold nat_le in *.
      sg_assoc S; sg_rewrite S w; sg_rewrite S e; sg_trivial S.
   Defined.

   Lemma x_le_y_y_le_z_x_le_z : forall (x y z : S), x <= y -> y <= z -> x <= z.
   Proof.
      intros x y z H H0.
      apply (le_trans _ _ _ H H0).
   Defined.

   Lemma x_nle_z_x_le_y_y_nle_z : forall (x y z : S), Not(x <= z) -> x <= y -> Not(y <= z).
   Proof.
      intros x y z H H0 H1.
      apply H. clear H.
      apply (le_trans x y z); trivial.
   Defined.
      
   Lemma x_nle_z_y_le_z_x_nle_y : forall (x y z : S), Not(x <= z) -> y <= z -> Not(x <= y).
   Proof.
      intros x y z H H0 H1.
      apply H.
      apply (le_trans _ _ _ H1 H0).
   Defined.

   (************************************************************************)  

   Close Scope Semigroup_scope. 

End NatOrder.

Notation "A <= B" := (nat_le _ A B) (at level 70, no associativity).



(************************************************************************)

   Open Scope Semigroup_scope.

   (* initial information about <= relation *)
   Ltac lex_assoc_init_1 S idem comm x y :=
              add_hyp (x + y <= y) (idem_x_plus_y_le_y S x y idem).

   Ltac lex_assoc_init_2 S idem comm x :=
	      add_hyp (x <= x) (idem_x_le_x S x idem).

   Ltac lex_assoc_init_3 S idem comm x y :=
	      add_hyp (x + y <= x) (comm_idem_x_plus_y_le_x S x y comm idem).

   Ltac lex_assoc_init S idem comm x y z :=
      try lex_assoc_init_1 S idem comm x y;
      try lex_assoc_init_1 S idem comm y z;
      try lex_assoc_init_2 S idem comm x;
      try lex_assoc_init_2 S idem comm y;
      try lex_assoc_init_2 S idem comm z;
      try lex_assoc_init_3 S idem comm x y;
      try lex_assoc_init_3 S idem comm y z.

   (* combine all lemmas into one big tactics *)
   Ltac lex_assoc_lemmas S idem comm x y z :=
       repeat (
         progress (
            match goal with
               | h1 : x <= y |- _ =>
                    add_hyp (x <= x + y) (idem_x_le_y_x_le_x_plus_y S _ _ idem h1)
               | h1 : y <= z |- _ =>
                    add_hyp (y <= y + z) (idem_x_le_y_x_le_x_plus_y S _ _ idem h1)
               | h1 : y <= x |- _ => 
                    add_hyp (y <= x + y) (idem_y_le_x_y_le_x_plus_y S _ _ idem h1)
               | h1 : z <= y |- _ => 
                    add_hyp (z <= y + z) (idem_y_le_x_y_le_x_plus_y S _ _ idem h1)
               | h1 : y <= x |- _ =>
                    add_hyp (x + y <= x) (y_le_x_x_plus_y_le_x S _ _ h1)
               | h1 : z <= y |- _ =>
                    add_hyp (y + z <= y) (y_le_x_x_plus_y_le_x S _ _ h1)
               | h1 : x <= y,h2 : x <= z |- _ =>
                    add_hyp (x <= y + z) (x_le_y_x_le_z_x_le_y_plus_z S _ _ _ h1 h2)
               | h1 : z <= y, h2 : z <= x |- _ =>
                    add_hyp (z <= x + y) (z_le_y_z_le_x_z_le_x_plus_y S _ _ _ h1 h2)
               | h1 : ?x <= ?y, h2 : ?y <= ?z |- _ =>
                    add_hyp (x <= z) (x_le_y_y_le_z_x_le_z S _ _ _ h1 h2)
               | h1 : Not(?x <= ?z), h2 : ?x <= ?y |- _ =>
                    add_hyp (Not(y <= z)) (x_nle_z_x_le_y_y_nle_z S _ _ _ h1 h2)
               | h1 : Not(?x <= ?z), h2 : ?y <= ?z |- _ =>
                    add_hyp (Not(x <= y)) (x_nle_z_y_le_z_x_nle_y S _ _ _ h1 h2)
            end
         )
      ). 

   Close Scope Semigroup_scope.
*)