Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.DecSetoidPropRecord.

Section poProp.
   Variable P : Preorder.
   Notation "'of' X" := (option (X P)) (at level 0).

   Record poProp :=
   {
      pp_dsprop             :> dsProp P;
      hasTop                : of HasTop;
      hasTop_comp           : of HasTop_comp;
      hasBottom             : of HasBottom;
      hasBottom_comp        : of HasBottom_comp;
      total                 : of Total;
      total_comp            : of Total_comp;
      antisym               : of Antisym;
      antisym_comp          : of Antisym_comp
   }.
End poProp.

   Definition poPropIso : forall {P P'} (I : ProIso P P'), poProp P -> poProp P'.
      intros P P' I pop; apply (Build_poProp _ (dsPropIso I pop)); destruct pop.
      apply (opfn (Iso_HasTop I)); trivial.
      apply (opfn (Iso_HasTop_comp I)); trivial.
      apply (opfn (Iso_HasBottom I)); trivial.
      apply (opfn (Iso_HasBottom_comp I)); trivial.
      apply (opfn (Iso_Total I)); trivial.
      apply (opfn (Iso_Total_comp I)); trivial.
      apply (opfn (Iso_Antisym I)); trivial.
      apply (opfn (Iso_Antisym_comp I)); trivial.
   Defined.