Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.OrderTransform.
Require Export Metarouting.Signatures.DecSetoidProperties.
Require Export Metarouting.Signatures.PreorderProperties.
Require Export Metarouting.Signatures.TransformProperties.

Section OrderTransformProperties.

   Open Scope OrderTransform_scope.
   
   Variable OT : OrderTransform.
   
   Definition Monotone      := forall x y : OT, forall f, x <= y -> f |> x <= f |> y.
   Definition Monotone_comp := Exists x y : OT, Exists f, x <= y /\ negb (f |> x <= f |> y).

   Definition Embedding      := Monotone -> forall x y : OT, forall f, f |> x <= f |> y -> x <= y.
   Definition Embedding_comp := Monotone -> Exists x y : OT, Exists f, f |> x <= f |> y /\ negb (x <= y).

   Definition Increasing      := forall x : OT, forall f, x <= f |> x.
   Definition Increasing_comp := Exists x : OT, Exists f, negb (x <= f |> x).

   Definition Decreasing      := forall x : OT, forall f, f |> x <= x.
   Definition Decreasing_comp := Exists x : OT, Exists f, negb (f |> x <= x).

End OrderTransformProperties.

Section OrderTransformIso.

   Ltac isoSimpl h iso :=
      rewrite 
         ?(pres_app iso), ?(pres_app' iso), 
         ?(inv iso), ?(inv' iso),
         ?(inv (fnIso iso)), ?(inv' (fnIso iso))
      in h.

   Ltac propIso h iso pos :=
      clear - h iso;
      hnf; 
      hnf in h;
      dseq_f;
      simpl;
      simpl in h;
      try match goal with
         | |- (forall (_ : carrier (setoid _)), _) => 
            let x := fresh "x" in
            let h' := fresh "h" in
            intros x; 
            match pos with
               | true  => assert (h' := h (phi' iso x))
               | false => assert (h' := h (phi iso x))
            end;
            propIso h' iso pos
         | |- (forall (_ : carrier (fn _)), _) => 
            let x := fresh "x" in
            let h' := fresh "h" in
            intros x; 
            match pos with
               | true  => assert (h' := h (phi' (fnIso iso) x))
               | false => assert (h' := h (phi  (fnIso iso) x))
            end;
            propIso h' iso pos
         | |- (@sigT (carrier (setoid _)) _) =>
            let x := fresh "x" in
            let h' := fresh "h" in
            destruct h as [x h'];
            match pos with
               | true  => exists (phi iso x)
               | false => exists (phi' iso x)
            end;
            propIso h' iso pos
         | |- (@sigT (carrier (fn _)) _) =>
            let x := fresh "x" in
            let h' := fresh "h" in
            destruct h as [x h'];
            match pos with
               | true  => exists (phi (fnIso iso) x)
               | false => exists (phi' (fnIso iso) x)
            end;
            propIso h' iso pos
         | |- (_ /\ _) =>
            let h' := fresh "h" in
            split; 
            [ destruct h as [h' _]; propIso h' iso pos
            | destruct h as [_ h']; propIso h' iso pos]
         | |- (_ \/ _) =>
            let h' := fresh "h" in
            destruct h as [h' | h'];
            [ apply or_introl; propIso h' iso pos
            | apply or_intror; propIso h' iso pos]
         | |- (_ == _) =>
            let h' := fresh "h" in
            match pos with
               | true  => assert (h' := pres_eq iso h)
               | false => assert (h' := pres_eq' iso h)
            end;
            repeat (progress (isoSimpl h' iso));
            try (apply h')
         | |- (_ -> _) =>
            let h' := fresh "h" in
            let h'' := fresh "h" in
            intros h';
            let ht := type of h in
            match ht with
               | (?X -> _) => assert X as h''
            end;
            [ match pos with
                 | true  => propIso h' iso false
                 | false => propIso h' iso true
              end
            | let h''' := fresh "h" in
              assert (h''' := h h'');
              propIso h''' iso pos
            ]
         | |- (bool_to_Prop (le _ _ _ )) =>
            let h' := fresh "h" in
            match pos with
               | true  => assert (h' := pres_le iso _ _ h)
               | false => assert (h' := pres_le' iso _ _ h)
            end;
            repeat (progress (isoSimpl h' iso));
            trivial
         | |- (bool_to_Prop (negb (le _ _ _))) =>
            let h' := fresh "h" in
            let h'' := fresh "h" in
            toProp; intros h'; elim h;
            match pos with
               | true  => assert (h'' := pres_le' iso _ _ h')
               | false => assert (h'' := pres_le iso _ _ h')
            end;
            repeat (progress (isoSimpl h'' iso));
            trivial
         | |- (_ -> False) =>
            let h' := fresh "h" in
            intros h'; elim h;
            match pos with
               | true  => propIso h' iso false
               | false => propIso h' iso true
            end
         | |- (bool_to_Prop _) =>
            progress (toProp);
            propIso h iso pos
      end.

   Lemma Iso_Monotone : forall {OT OT'} (I : OTfIso OT OT'), Monotone OT -> Monotone OT'.
   Proof. intros OT OT' I h; propIso h I true. Defined.

   Lemma Iso_Monotone_comp : forall {OT OT'} (I : OTfIso OT OT'), Monotone_comp OT -> Monotone_comp OT'.
   Proof. intros OT OT' I h; propIso h I true. Defined.

   Lemma Iso_Embedding : forall {OT OT'} (I : OTfIso OT OT'), Embedding OT -> Embedding OT'.
   Proof. intros OT OT' I h mon.
      assert (h' := h (Iso_Monotone (OTfIso_sym I) mon)).
      propIso h' I true. 
   Defined.

   Lemma Iso_Embedding_comp : forall {OT OT'} (I : OTfIso OT OT'), Embedding_comp OT -> Embedding_comp OT'.
   Proof. intros OT OT' I h mon.
      assert (h' := h (Iso_Monotone (OTfIso_sym I) mon)).
      propIso h' I true. 
   Defined.

   Lemma Iso_Increasing : forall {OT OT'} (I : OTfIso OT OT'), Increasing OT -> Increasing OT'.
   Proof. intros OT OT' I h; propIso h I true. Defined.

   Lemma Iso_Increasing_comp : forall {OT OT'} (I : OTfIso OT OT'), Increasing_comp OT -> Increasing_comp OT'.
   Proof. intros OT OT' I h; propIso h I true. Defined.

   Lemma Iso_Decreasing : forall {OT OT'} (I : OTfIso OT OT'), Decreasing OT -> Decreasing OT'.
   Proof. intros OT OT' I h; propIso h I true. Defined.

   Lemma Iso_Decreasing_comp : forall {OT OT'} (I : OTfIso OT OT'), Decreasing_comp OT -> Decreasing_comp OT'.
   Proof. intros OT OT' I h; propIso h I true. Defined.

End OrderTransformIso.
