Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.OrderTransform.
Require Import Metarouting.Signatures.OrderTransformProperties.
Require Export Metarouting.Signatures.PreorderPropRecord.
Require Export Metarouting.Signatures.TransformPropRecord.

Section otProp.
   Variable OT : OrderTransform.
   Notation "'of' P" := (option (P OT)) (at level 0).

   Record otProp :=
   {
      ot_poprop                            :> poProp OT;
      ot_tfprop                            :> tfProp OT;
      monotone                             : of Monotone;
      monotone_comp                        : of Monotone_comp;
      embedding                            : of Embedding;
      embedding_comp                       : of Embedding_comp;
      increasing                           : of Increasing;
      increasing_comp                      : of Increasing_comp
   }.
End otProp.


   Definition otPropIso : forall {S S'} (I : OTfIso S S'), otProp S -> otProp S'.
      intros S S' I stp; apply (Build_otProp _ (poPropIso I stp) (tfPropIso I stp)); destruct stp.
      apply (opfn (Iso_Monotone I)); trivial.
      apply (opfn (Iso_Monotone_comp I)); trivial.
      apply (opfn (Iso_Embedding I)); trivial.
      apply (opfn (Iso_Embedding_comp I)); trivial.
      apply (opfn (Iso_Increasing I)); trivial.
      apply (opfn (Iso_Increasing_comp I)); trivial.
   Defined.