Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.OrderSemigroupProperties.
Require Import Metarouting.Signatures.PreorderPropRecord.
Require Import Metarouting.Signatures.SemigroupPropRecord.

Section osProp.
   Variable OS : OrderSemigroup.
   Notation "'of' P" := (option (P OS)) (at level 0).

   Record osProp :=
   {
      os_sgprop                         :> sgProp OS;
      os_poprop                         :> poProp OS;
      leftMonotonic                     : of LeftMonotonic;
      leftMonotonic_comp                : of LeftMonotonic_comp;
      rightMonotonic                    : of RightMonotonic;
      rightMonotonic_comp               : of RightMonotonic_comp;
      topIsAnnihilator                  : of TopIsAnnihilator;
      topIsAnnihilator_comp             : of TopIsAnnihilator_comp;
      topIsIdentity                     : of TopIsIdentity;
      topIsIdentity_comp                : of TopIsIdentity_comp;
      bottomIsAnnihilator               : of BottomIsAnnihilator;
      bottomIsAnnihilator_comp          : of BottomIsAnnihilator_comp;
      bottomIsIdentity                  : of BottomIsIdentity;
      bottomIsIdentity_comp             : of BottomIsIdentity_comp;
      leftOpNonDecreasing               : of LeftOpNonDecreasing;
      leftOpNonDecreasing_comp          : of LeftOpNonDecreasing_comp;
      rightOpNonDecreasing              : of RightOpNonDecreasing;
      rightOpNonDecreasing_comp         : of RightOpNonDecreasing_comp;
      selectiveOpNonDecreasing          : of SelectiveOpNonDecreasing;
      selectiveOpNonDecreasing_comp     : of SelectiveOpNonDecreasing_comp;
      leftOpIncreasing                  : of LeftOpIncreasing;
      leftOpIncreasing_comp             : of LeftOpIncreasing_comp;
      rightOpIncreasing                 : of RightOpIncreasing;
      rightOpIncreasing_comp            : of RightOpIncreasing_comp;
      leftEquivCancelative              : of LeftEquivCancelative;
      leftEquivCancelative_comp         : of LeftEquivCancelative_comp;
      rightEquivCancelative             : of RightEquivCancelative;
      rightEquivCancelative_comp        : of RightEquivCancelative_comp;
      leftEquivCondensed                : of LeftEquivCondensed;
      leftEquivCondensed_comp           : of LeftEquivCondensed_comp;
      rightEquivCondensed               : of RightEquivCondensed;
      rightEquivCondensed_comp          : of RightEquivCondensed_comp;
      incompArrowUniqueSrc              : of IncompArrowUniqueSrc;
      incompArrowUniqueSrc_comp         : of IncompArrowUniqueSrc_comp;
      incompArrowFactor                 : of IncompArrowFactor;
      incompArrowFactor_comp            : of IncompArrowFactor_comp
   }.
End osProp.

   Definition osPropIso : forall {O O'} (I : OSmgIso O O'), osProp O -> osProp O'.
      intros O O' I osp; apply (Build_osProp _ (sgPropIso I osp) (poPropIso I osp)); destruct osp.
      apply (opfn (Iso_LeftMonotonic I)); trivial.
      apply (opfn (Iso_LeftMonotonic_comp I)); trivial.
      apply (opfn (Iso_RightMonotonic I)); trivial.
      apply (opfn (Iso_RightMonotonic_comp I)); trivial.
      apply (opfn (Iso_TopIsAnnihilator I)); trivial.
      apply (opfn (Iso_TopIsAnnihilator_comp I)); trivial.
      apply (opfn (Iso_TopIsIdentity I)); trivial.
      apply (opfn (Iso_TopIsIdentity_comp I)); trivial.
      apply (opfn (Iso_BottomIsAnnihilator I)); trivial.
      apply (opfn (Iso_BottomIsAnnihilator_comp I)); trivial.
      apply (opfn (Iso_BottomIsIdentity I)); trivial.
      apply (opfn (Iso_BottomIsIdentity_comp I)); trivial.
      apply (opfn (Iso_LeftOpNonDecreasing I)); trivial.
      apply (opfn (Iso_LeftOpNonDecreasing_comp I)); trivial.
      apply (opfn (Iso_RightOpNonDecreasing I)); trivial.
      apply (opfn (Iso_RightOpNonDecreasing_comp I)); trivial.
      apply (opfn (Iso_SelectiveOpNonDecreasing I)); trivial.
      apply (opfn (Iso_SelectiveOpNonDecreasing_comp I)); trivial.
      apply (opfn (Iso_LeftOpIncreasing I)); trivial.
      apply (opfn (Iso_LeftOpIncreasing_comp I)); trivial.
      apply (opfn (Iso_RightOpIncreasing I)); trivial.
      apply (opfn (Iso_RightOpIncreasing_comp I)); trivial.
      apply (opfn (Iso_LeftEquivCancelative I)); trivial.
      apply (opfn (Iso_LeftEquivCancelative_comp I)); trivial.
      apply (opfn (Iso_RightEquivCancelative I)); trivial.
      apply (opfn (Iso_RightEquivCancelative_comp I)); trivial.
      apply (opfn (Iso_LeftEquivCondensed I)); trivial.
      apply (opfn (Iso_LeftEquivCondensed_comp I)); trivial.
      apply (opfn (Iso_RightEquivCondensed I)); trivial.
      apply (opfn (Iso_RightEquivCondensed_comp I)); trivial.
      apply (opfn (Iso_IncompArrowUniqueSrc I)); trivial.
      apply (opfn (Iso_IncompArrowUniqueSrc_comp I)); trivial.
      apply (opfn (Iso_IncompArrowFactor I)); trivial.
      apply (opfn (Iso_IncompArrowFactor_comp I)); trivial.
   Defined.