Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Signatures.PreorderProperties.
Require Import Metarouting.Signatures.PreorderPropRecord.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Signatures.IdArrow.

Section Glue.

   Definition glueOSmg : forall (A : Semigroup) (B : Preorder), DsEq A B -> OrderSemigroup.
     intros A B e. (*unfold DsEq in *.*)
     assert (q := @Build_OrderSemigroup 
              (*(@Build_DecSetoid B (choose B) (@equal B) (refl B) (sym B) (trans B))*)
              B
              (Preorder.le B)
              (Preorder.le_refl B)
              (Preorder.le_trans B)
              (Preorder.le_pres_eq B)
            ).
     simpl in q.
     destruct e.
     apply (q (Semigroup.op A) 
              (Semigroup.assoc A) 
              (Semigroup.op_pres_eq A)).
   Defined.

   Lemma glueOSmg_IdSmgIso : forall A B e, IdSmgIso (glueOSmg A B e) A.
      intros. destruct A; destruct B; simpl in *; destruct e; auto.
      (*destruct A; destruct setoid;
      destruct B; destruct setoid;
      unfold DsEq in e; simpl in *; destruct e. auto.*)
   Defined.

   Lemma glueOSmg_IdProIso : forall A B e, IdProIso (glueOSmg A B e) B.
      intros; destruct A; destruct B; simpl in *; destruct e; auto.
      (*destruct A; destruct setoid;
      destruct B; destruct setoid;
      unfold DsEq in e; simpl in *; destruct e. auto.*)
   Defined.
   
   Definition projSmgOSmgIso : forall A B e, sgProp A -> sgProp (glueOSmg A B e).
      intros A B e h.
      destruct A; destruct B; simpl in *.
      destruct e; auto.
      (*destruct setoid; destruct setoid0; simpl in *.
      unfold DsEq in e; simpl in *.
      destruct e; simpl.
      unfold semigroupOS; simpl. 
      auto.*)
   Defined.

   Definition projProOSmgIso : forall A B e, poProp B -> poProp (glueOSmg A B e).
      intros A B e h.
      destruct A; destruct B; simpl in *.
      destruct e; auto.
      (*destruct setoid; destruct setoid0; simpl in *.
      unfold DsEq in e; simpl in *.
      destruct e; simpl.
      unfold preorderOS; simpl. 
      auto.*)
   Defined.

End Glue.