Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.DecSetoidProperties.

Section dsProp.

   Variable D : DecSetoid.

   Notation "'of' P" := (option (P D)) (at level 0).

   Record dsProp :=
   {
      isSingleton      : of IsSingleton;
      isSingleton_comp : of IsSingleton_comp;
      twoElements      : of TwoElements;
      twoElements_comp : of TwoElements_comp;
      finite           : of Finite;
      finite_comp      : of Finite_comp
   }.
End dsProp.

   Definition dsPropIso : forall {D D'} (I : DsIso D D'), dsProp D -> dsProp D'.
      intros D D' I dsp; destruct dsp; apply Build_dsProp. 
      apply (opfn (Iso_IsSingleton I)); trivial.
      apply (opfn (Iso_IsSingleton_comp I)); trivial.
      apply (opfn (Iso_TwoElements I)); trivial.
      apply (opfn (Iso_TwoElements_comp I)); trivial.
      apply (opfn (Iso_Finite I)); trivial.
      apply (opfn (Iso_Finite_comp I)); trivial.
   Defined.