Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.


(* 

   This is just a first attempt at putting complementary properties together. 
*) 

Section ComplementaryProperties.

Definition complement {T} (P : T -> Type) (Q : T -> Type) :=
   forall t : T, P t -> Q t -> False.

Record ComplementaryProps {T : Type} : Type := 
   {
      positive    : T -> Type; 
      negative    : T -> Type; 
      comp_condition : complement positive negative
   }.

Definition Proof {T} (P : ComplementaryProps) (t : T) : Type :=
   (positive P t) \/ (negative P t).

Lemma hasIdentityPairComp : complement HasIdentity HasIdentity_comp.
Proof. intros S [a [P1 P2]] Q; destruct (Q a) as [[b Q1] | [b Q1]]; auto. Qed.

Lemma hasAnnihilatorPairComp : complement HasAnnihilator HasAnnihilator_comp.
Proof. intros S [a [P1 P2]] Q; destruct (Q a) as [[b Q1] | [b Q1]]; auto. Qed.

Lemma isSelectivePairComp : complement IsSelective IsSelective_comp.
Proof. intros S P [a [b [Q1 Q2]]]. destruct (P a b) as [P1 | P1]; auto. Qed.

Lemma isCommutativePairComp : complement IsCommutative IsCommutative_comp.
Proof. intros S P [a [b Q]]; auto. Qed.

Lemma isIdempotentPairComp : complement IsIdempotent IsIdempotent_comp.
Proof. intros S P [a Q]; auto. Qed.

Lemma isLeftPairComp : complement IsLeft IsLeft_comp.
Proof. intros S P [a [b Q]]; auto. Qed.

Lemma isRightPairComp : complement IsRight IsRight_comp.
Proof. intros S P [a [b Q]]; auto. Qed.

Lemma leftCondensedPairComp : complement LeftCondensed LeftCondensed_comp.
Proof. intros S P [a [b [c Q]]]; auto. Qed.

Lemma rightCondensedPairComp : complement RightCondensed RightCondensed_comp.
Proof. intros S P [a [b [c Q]]]; auto. Qed.

Definition HasIdentityPair    : ComplementaryProps := Build_ComplementaryProps _ _ _ hasIdentityPairComp.
Definition HasAnnihilatorPair : ComplementaryProps := Build_ComplementaryProps _ _ _ hasAnnihilatorPairComp.
Definition IsSelectivePair    : ComplementaryProps := Build_ComplementaryProps _ _ _ isSelectivePairComp.
Definition IsCommutativePair  : ComplementaryProps := Build_ComplementaryProps _ _ _ isCommutativePairComp.
Definition IsIdempotentPair   : ComplementaryProps := Build_ComplementaryProps _ _ _ isIdempotentPairComp.
Definition IsLeftPair         : ComplementaryProps := Build_ComplementaryProps _ _ _ isLeftPairComp.
Definition IsRightPair        : ComplementaryProps := Build_ComplementaryProps _ _ _ isRightPairComp.
Definition LeftCondensedPair  : ComplementaryProps := Build_ComplementaryProps _ _ _ leftCondensedPairComp.
Definition RightCondensedPair : ComplementaryProps := Build_ComplementaryProps _ _ _ rightCondensedPairComp.

Canonical Structure HasIdentityPair. 
Canonical Structure HasAnnihilatorPair. 
Canonical Structure IsSelectivePair. 
Canonical Structure IsCommutativePair. 
Canonical Structure IsIdempotentPair.
Canonical Structure IsLeftPair. 
Canonical Structure IsRightPair. 
Canonical Structure LeftCondensedPair. 
Canonical Structure RightCondensedPair.

Eval simpl in (negative HasIdentityPair).
   

   Record sgProp (S : Semigroup) :=
   {
      sg_dsprop             :> dsProp S;
      hasIdentity           : option (Proof HasIdentityPair S);
      hasAnnihilator        : option (Proof HasAnnihilatorPair S);
      isSelective           : option (Proof IsSelectivePair S);
      isCommutative         : option (Proof IsCommutativePair S);
      isIdempotent          : option (Proof IsIdempotentPair S);
      isLeft                : option (Proof IsLeftPair S);
      isRight               : option (Proof IsRightPair S);
      leftCondensed         : option (Proof LeftCondensedPair S);
      rightCondensed        : option (Proof RightCondensedPair S)
   }.

Lemma identity_pair_is_compl : forall S : Semigroup, 
         Not (HasIdentity S /\ HasIdentity_comp S).
Proof.
   intros S [[a H] P].
   red in P.
   red in H.
   destruct H as [H1 H2].
   assert (Q := P a).
   red in Q.
   destruct Q.
   red in H1, n.
   destruct n as [b Q].
   assert (W := H1 b).
   apply (Q W).
   red in H2, n.
   destruct n as [b Q].
   assert (W := H2 b).
   apply (Q W).
Qed.

Definition identity_pair := Build_ComplementaryProps Semigroup HasIdentity HasIdentity_comp identity_pair_is_compl.

End ComplementaryProperties.

