Require Import Metarouting.Logic.Logic.
Require Export Metarouting.Signatures.SemigroupProperties.
Require Export Metarouting.Signatures.DecSetoidProperties.
Require Import Metarouting.Signatures.Bisemigroup.

Section BisemigroupProperties.

   Open Scope Bisemigroup_scope.

   Variable BS : Bisemigroup.

   Definition IsLeftDistributive      := forall a b c : BS, c * (a + b) == c * a + c * b.
   Definition IsLeftDistributive_comp := Exists a b c : BS, c * (a + b) != c * a + c * b.

   Definition IsRightDistributive      := forall a b c : BS, (a + b) * c == a * c + b * c.
   Definition IsRightDistributive_comp := Exists a b c : BS, (a + b) * c != a * c + b * c.

(*   Definition IsLeftCoDistributive      := forall a b c : BS, c + a * b == (c + a) * (c + b).
   Definition IsLeftCoDistributive_comp := Exists a b c : BS, c + a * b != (c + a) * (c + b).

   Definition IsRightCoDistributive      := forall a b c : BS, a * b + c == (a + c) * (b + c).
   Definition IsRightCoDistributive_comp := Exists a b c : BS, a * b + c != (a + c) * (b + c).
*)

   Definition PlusIdentityIsTimesAnnihilator := 
      forall hasPlusId : HasIdentity (plusSmg BS), let plusId := projT1 hasPlusId in
      forall hasTimesAnn : HasAnnihilator (timesSmg BS), let timesAnn := projT1 hasTimesAnn in
      plusId == timesAnn.
   Definition PlusIdentityIsTimesAnnihilator_comp :=
      forall hasPlusId : HasIdentity (plusSmg BS), let plusId := projT1 hasPlusId in
      forall hasTimesAnn : HasAnnihilator (timesSmg BS), let timesAnn := projT1 hasTimesAnn in
      plusId != timesAnn.

   Definition PlusAnnihilatorIsTimesIdentity :=
      forall hasPlusAnn : HasAnnihilator (plusSmg BS), let plusAnn := projT1 hasPlusAnn in
      forall hasTimesId : HasIdentity (timesSmg BS), let timesId := projT1 hasTimesId in
      plusAnn == timesId.
   Definition PlusAnnihilatorIsTimesIdentity_comp :=
      forall hasPlusAnn : HasAnnihilator (plusSmg BS), let plusAnn := projT1 hasPlusAnn in
      forall hasTimesId : HasIdentity (timesSmg BS), let timesId := projT1 hasTimesId in
      plusAnn != timesId.

   (* Conditional properties *)
   Section LatticeProps.
      Definition IsRightStrictStable := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall a a0 a1 : BS, (a < a0 /\ a * a1 < a0 * a1) \/ (negb (a < a0) /\ negb (a * a1 < a0 * a1)).
      Definition IsRightStrictStable_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists a a0 a1 : BS, (negb (a < a0) \/ negb(a * a1 < a0 * a1)) /\ (a < a0 \/ a * a1 < a0 * a1).

      Definition IsLeftStrictStable := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall a a0 a1 : BS, (a < a0 /\ a1 * a < a1 * a0) \/ (negb (a < a0) /\ negb(a1 * a < a1 * a0)).
      Definition IsLeftStrictStable_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists a a0 a1 : BS, (negb(a < a0) \/ negb(a1 * a < a1 * a0)) /\ (a < a0 \/ a1 * a < a1 * a0).

      Definition IsRightCompEqCancel := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y z : BS, x * z == y * z -> (x <=> y).
      Definition IsRightCompEqCancel_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y z : BS, x * z == y * z /\ (x # y).

      Definition IsLeftCompEqCancel := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y z : BS, z * x == z * y -> (x <=> y).
      Definition IsLeftCompEqCancel_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y z : BS, z * x == z * y /\ (x # y).

      Definition IsRightCompCancel := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y z : BS, x * z # y * z -> (x <=> y).
      Definition IsRightCompCancel_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y z : BS, x * z # y * z /\ (x # y).

      Definition IsLeftCompCancel := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y z : BS, z * x # z * y -> (x <=> y).
      Definition IsLeftCompCancel_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y z : BS, z * x # z * y /\ (x # y).

      Definition LeftDiscrete := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y z : BS, negb (z * x < z * y).
      Definition LeftDiscrete_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y z : BS, z * x < z * y.

      Definition RightDiscrete := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y z : BS, negb (x * z < y * z).
      Definition RightDiscrete_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y z : BS, x * z < y * z.

      Definition LeftComparable := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y z : BS, z * x <=> z * y.
      Definition LeftComparable_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y z : BS, z * x # z * y.

      Definition RightComparable := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y z : BS, x * z <=> y * z.
      Definition RightComparable_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y z : BS, x * z # y * z.

      Definition RightIncreasing := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y : BS, x + x * y == x.
   
      Definition RightIncreasing_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y : BS, x + x * y != x.

      Definition LeftIncreasing := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y : BS, x + y * x == x.
   
      Definition LeftIncreasing_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y : BS, x + y * x != x.

      Definition RightStrictIncreasing := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y : BS, x < x * y.

      Definition RightStrictIncreasing_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y : BS, negb (x < x * y).
      
      Definition LeftStrictIncreasing := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall x y : BS, x < y * x.

      Definition LeftStrictIncreasing_comp := IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         Exists x y : BS, negb (x < y * x).

      Definition LeftWStrictIncreasing :=       
         IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall hasW : HasAnnihilator (plusSmg BS), let w := projT1 hasW in
         forall x y : BS, x != w -> (x < y * x).
      Definition LeftWStrictIncreasing_comp :=       
         IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall hasW : HasAnnihilator (plusSmg BS), let w := projT1 hasW in
         Exists x y : BS, x != w /\ negb(x < y * x).
      Definition RightWStrictIncreasing :=       
         IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall hasW : HasAnnihilator (plusSmg BS), let w := projT1 hasW in
         forall x y : BS, x != w -> (x < x * y).
      Definition RightWStrictIncreasing_comp :=       
         IsCommutative (plusSmg BS) -> IsIdempotent (plusSmg BS) ->
         forall hasW : HasAnnihilator (plusSmg BS), let w := projT1 hasW in
         Exists x y : BS, x != w /\ negb(x < x * y).

   End LatticeProps.
   
   Section IdProps.
      Definition IsRightTimesMapToIdConstantPlus := forall hasId : HasIdentity (plusSmg BS), let id := projT1 hasId in
         forall x y z : BS, x * z + y * z == id * z.
      Definition IsRightTimesMapToIdConstantPlus_comp := forall hasId : HasIdentity (plusSmg BS), let id := projT1 hasId in
         Exists x y z : BS, x * z + y * z != id * z.

      Definition IsLeftTimesMapToIdConstantPlus := forall hasId : HasIdentity (plusSmg BS), let id := projT1 hasId in
         forall x y z : BS, z * x + z * y == z * id.
      Definition IsLeftTimesMapToIdConstantPlus_comp := forall hasId : HasIdentity (plusSmg BS), let id := projT1 hasId in
         Exists x y z : BS, z * x + z * y != z * id.

      Definition PlusIdentityIsTimesLeftAnnihilator := forall hasId : HasIdentity (plusSmg BS), let id := projT1 hasId in
         forall x, id * x == id.
      Definition PlusIdentityIsTimesLeftAnnihilator_comp := forall hasId : HasIdentity (plusSmg BS), let id := projT1 hasId in
         Exists x, id * x != id.

      Definition PlusIdentityIsTimesRightAnnihilator := forall hasId : HasIdentity (plusSmg BS), let id := projT1 hasId in
         forall x, x * id == id.
      Definition PlusIdentityIsTimesRightAnnihilator_comp := forall hasId : HasIdentity (plusSmg BS), let id := projT1 hasId in
         Exists x, x * id != id.

   End IdProps.

   Close Scope Bisemigroup_scope.
   
End BisemigroupProperties.

(****************************************************************)
(* Isomorphic bisemigroups have the same properties of interest *)
(****************************************************************)

Section BisemigroupIso.

(*
   Lemma IsoPresId : forall {B B'} (iso : BSmgIso B B') 
                            (hasId  : HasIdentity (plusSmg B))
                            (hasId' : HasIdentity (plusSmg B')),
                            (phi iso (projT1 hasId) == projT1 hasId').
   Proof. intros B B' iso [id p] [id' p']; simpl in *;
      destruct (p (phi' iso id')) as [q _]; destruct (p' (phi iso id)) as [_ q'];
      assert (q'' := pres_eq iso q).
      rewrite (pres_plus iso) in q''. rewrite (inv iso) in q'';
      rewrite <- q', q''; trivial.
   Defined.

   Lemma IsoPresId' : forall {B B'} (iso : BSmgIso B B') 
                            (hasId  : HasIdentity (plusSmg B))
                            (hasId' : HasIdentity (plusSmg B')),
                            (phi' iso (projT1 hasId') == projT1 hasId).
   Proof. intros B B' iso [id p] [id' p']; simpl in *;
      destruct (p (phi' iso id')) as [_ q]; destruct (p' (phi iso id)) as [q' _];
      assert (q'' := pres_eq' iso q');
      rewrite (pres_plus' iso), (inv' iso) in q'';
      rewrite <- q, q''; trivial.
   Defined.
*)

   Ltac isoSimpl h iso :=
      simpl in h; (* remove projections to semigroups *)
      rewrite 
          (*?(IsoPresId iso), ?(IsoPresId' iso), *)
          ?(pres_plus iso), ?(pres_plus' iso), 
          ?(pres_times iso), ?(pres_times' iso), 
          ?(inv iso), ?(inv' iso) in h.

   Ltac propIso h iso pos :=
      clear - h iso;
      hnf; 
      hnf in h;
      dseq_f;
      try match goal with
         | |- False => apply h
         | |- (forall _, _) => 
            let x := fresh "x" in
            let h' := fresh "h" in
            intros x; 
            match pos with
               | true  => assert (h' := h (phi' iso x))
               | false => assert (h' := h (phi iso x))
            end;
            propIso h' iso pos
         | |- (@sigT _ _) =>
            let x := fresh "x" in
            let h' := fresh "h" in
            destruct h as [x h'];
            match pos with
               | true  => exists (phi iso x)
               | false => exists (phi' iso x)
            end;
            propIso h' iso pos
         | |- (_ /\ _) =>
            let h' := fresh "h" in
            split; 
            [ destruct h as [h' _]; propIso h' iso pos
            | destruct h as [_ h']; propIso h' iso pos]
         | |- (_ \/ _) =>
            let h' := fresh "h" in
            destruct h as [h' | h'];
            [ apply or_introl; propIso h' iso pos
            | apply or_intror; propIso h' iso pos]
         | |- (_ -> _) =>
            let h' := fresh "h" in
            let h'' := fresh "h" in
            intros h';
            let ht := type of h in
            match ht with
               | (?X -> _) => assert X as h''
            end;
            [ match pos with
                 | true  => propIso h' iso false
                 | false => propIso h' iso true
              end
            | let h''' := fresh "h" in
              assert (h''' := h h'');
              propIso h''' iso pos
            ]
         | |- (_ == _) =>
            let h' := fresh "h" in
            match pos with
               | true  => assert (h' := pres_eq iso h)
               | false => assert (h' := pres_eq' iso h)
            end;
            repeat (progress (isoSimpl h' iso));
            try (apply h')
         | |- (_ -> False) =>
            let h' := fresh "h" in
            intros h'; elim h;
            match pos with
               | true  => propIso h' iso false
               | false => propIso h' iso true
            end
         | |- (bool_to_Prop _) =>
            progress (toProp);
            propIso h iso pos
      end.

   Lemma Iso_IsLeftDistributive : forall {B B'} (I : BSmgIso B B'), IsLeftDistributive B -> IsLeftDistributive B'.
   Proof. intros B B' I h; propIso h I true. Defined.

   Lemma Iso_IsLeftDistributive_comp : forall {B B'} (I : BSmgIso B B'), IsLeftDistributive_comp B -> IsLeftDistributive_comp B'.
   Proof. intros B B' I h; propIso h I true. Defined.

   Lemma Iso_IsRightDistributive : forall {B B'} (I : BSmgIso B B'), IsRightDistributive B -> IsRightDistributive B'.
   Proof. intros B B' I h; propIso h I true. Defined.

   Lemma Iso_IsRightDistributive_comp : forall {B B'} (I : BSmgIso B B'), IsRightDistributive_comp B -> IsRightDistributive_comp B'.
   Proof. intros B B' I h; propIso h I true. Defined.

(*   Lemma Iso_IsLeftCoDistributive : forall {B B'} (I : BSmgIso B B'), IsLeftCoDistributive B -> IsLeftCoDistributive B'.
   Proof. intros B B' I h; propIso h I true. Defined.

   Lemma Iso_IsLeftCoDistributive_comp : forall {B B'} (I : BSmgIso B B'), IsLeftCoDistributive_comp B -> IsLeftCoDistributive_comp B'.
   Proof. intros B B' I h; propIso h I true. Defined.

   Lemma Iso_IsRightCoDistributive : forall {B B'} (I : BSmgIso B B'), IsRightCoDistributive B -> IsRightCoDistributive B'.
   Proof. intros B B' I h; propIso h I true. Defined.

   Lemma Iso_IsRightCoDistributive_comp : forall {B B'} (I : BSmgIso B B'), IsRightCoDistributive_comp B -> IsRightCoDistributive_comp B'.
   Proof. intros B B' I h; propIso h I true. Defined. *)

   Ltac SpecElPropsIso D1 D2 iso :=
      let h := fresh "h" in
      let h' := fresh "h" in
      let P := fresh "P" in
      let P' := fresh "P'" in
      let Q := fresh "Q" in
      let Q' := fresh "Q'" in
      intros h P' Q';
      assert (D1) as P; [ propIso P' iso false |];
      assert (D2) as Q; [ propIso Q' iso false |];
      assert (h' := h P Q);
      propIso h' iso true.

   Lemma Iso_PlusIdentityIsTimesAnnihilator : forall {B B'} (I : BSmgIso B B'), PlusIdentityIsTimesAnnihilator B -> PlusIdentityIsTimesAnnihilator B'.
   Proof. intros B B' I; SpecElPropsIso (HasIdentity (plusSmg B)) (HasAnnihilator (timesSmg B)) I;
      rewrite (Iso_PresId' (plusSmgBSmgIso I) P P'), (Iso_PresAnn' (timesSmgBSmgIso I) Q Q') in h; auto.
   Defined.

   Lemma Iso_PlusIdentityIsTimesAnnihilator_comp : forall {B B'} (I : BSmgIso B B'), PlusIdentityIsTimesAnnihilator_comp B -> PlusIdentityIsTimesAnnihilator_comp B'.
   Proof. intros B B' I; SpecElPropsIso (HasIdentity (plusSmg B)) (HasAnnihilator (timesSmg B)) I.
      rewrite (Iso_PresId (plusSmgBSmgIso I) P P'), (Iso_PresAnn (timesSmgBSmgIso I) Q Q') in h0; auto.
   Defined.

   Lemma Iso_PlusAnnihilatorIsTimesIdentity : forall {B B'} (I : BSmgIso B B'), PlusAnnihilatorIsTimesIdentity B -> PlusAnnihilatorIsTimesIdentity B'.
   Proof. intros B B' I; SpecElPropsIso (HasAnnihilator (plusSmg B)) (HasIdentity (timesSmg B)) I.
      rewrite (Iso_PresAnn' (plusSmgBSmgIso I) P P'), (Iso_PresId' (timesSmgBSmgIso I) Q Q') in h; auto.
   Defined.

   Lemma Iso_PlusAnnihilatorIsTimesIdentity_comp : forall {B B'} (I : BSmgIso B B'), PlusAnnihilatorIsTimesIdentity_comp B -> PlusAnnihilatorIsTimesIdentity_comp B'.
   Proof. intros B B' I; SpecElPropsIso (HasAnnihilator (plusSmg B)) (HasIdentity (timesSmg B)) I.
      rewrite (Iso_PresAnn (plusSmgBSmgIso I) P P'), (Iso_PresId (timesSmgBSmgIso I) Q Q') in h0; auto.
   Defined.

   Ltac LatticePropsIso B iso :=
      let h := fresh "h" in
      let h' := fresh "h" in
      let comm := fresh "comm" in
      let idem := fresh "idem" in
      let comm' := fresh "comm" in
      let idem' := fresh "idem" in
      intros h comm' idem';
      assert (IsCommutative (plusSmg B)) as comm; [propIso comm' iso false|];
      assert (IsIdempotent (plusSmg B)) as idem; [propIso idem' iso false|];
      assert (h' := h comm idem); 
      propIso h' iso true.

   Lemma Iso_IsRightStrictStable : forall {B B'} (I : BSmgIso B B'), IsRightStrictStable B -> IsRightStrictStable B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsRightStrictStable_comp : forall {B B'} (I : BSmgIso B B'), IsRightStrictStable_comp B -> IsRightStrictStable_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsLeftStrictStable : forall {B B'} (I : BSmgIso B B'), IsLeftStrictStable B -> IsLeftStrictStable B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsLeftStrictStable_comp : forall {B B'} (I : BSmgIso B B'), IsLeftStrictStable_comp B -> IsLeftStrictStable_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsRightCompEqCancel : forall {B B'} (I : BSmgIso B B'), IsRightCompEqCancel B -> IsRightCompEqCancel B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsRightCompEqCancel_comp : forall {B B'} (I : BSmgIso B B'), IsRightCompEqCancel_comp B -> IsRightCompEqCancel_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsLeftCompEqCancel : forall {B B'} (I : BSmgIso B B'), IsLeftCompEqCancel B -> IsLeftCompEqCancel B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsLeftCompEqCancel_comp : forall {B B'} (I : BSmgIso B B'), IsLeftCompEqCancel_comp B -> IsLeftCompEqCancel_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsRightCompCancel : forall {B B'} (I : BSmgIso B B'), IsRightCompCancel B -> IsRightCompCancel B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsRightCompCancel_comp : forall {B B'} (I : BSmgIso B B'), IsRightCompCancel_comp B -> IsRightCompCancel_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsLeftCompCancel : forall {B B'} (I : BSmgIso B B'), IsLeftCompCancel B -> IsLeftCompCancel B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_IsLeftCompCancel_comp : forall {B B'} (I : BSmgIso B B'), IsLeftCompCancel_comp B -> IsLeftCompCancel_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_LeftDiscrete : forall {B B'} (I : BSmgIso B B'), LeftDiscrete B -> LeftDiscrete B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_LeftDiscrete_comp : forall {B B'} (I : BSmgIso B B'), LeftDiscrete_comp B -> LeftDiscrete_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_RightDiscrete : forall {B B'} (I : BSmgIso B B'), RightDiscrete B -> RightDiscrete B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_RightDiscrete_comp : forall {B B'} (I : BSmgIso B B'), RightDiscrete_comp B -> RightDiscrete_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_LeftComparable : forall {B B'} (I : BSmgIso B B'), LeftComparable B -> LeftComparable B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_LeftComparable_comp : forall {B B'} (I : BSmgIso B B'), LeftComparable_comp B -> LeftComparable_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_RightComparable : forall {B B'} (I : BSmgIso B B'), RightComparable B -> RightComparable B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_RightComparable_comp : forall {B B'} (I : BSmgIso B B'), RightComparable_comp B -> RightComparable_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_LeftIncreasing : forall {B B'} (I : BSmgIso B B'), LeftIncreasing B -> LeftIncreasing B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_LeftIncreasing_comp : forall {B B'} (I : BSmgIso B B'), LeftIncreasing_comp B -> LeftIncreasing_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_RightIncreasing : forall {B B'} (I : BSmgIso B B'), RightIncreasing B -> RightIncreasing B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_RightIncreasing_comp : forall {B B'} (I : BSmgIso B B'), RightIncreasing_comp B -> RightIncreasing_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_LeftStrictIncreasing : forall {B B'} (I : BSmgIso B B'), LeftStrictIncreasing B -> LeftStrictIncreasing B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_LeftStrictIncreasing_comp : forall {B B'} (I : BSmgIso B B'), LeftStrictIncreasing_comp B -> LeftStrictIncreasing_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_RightStrictIncreasing : forall {B B'} (I : BSmgIso B B'), RightStrictIncreasing B -> RightStrictIncreasing B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Lemma Iso_RightStrictIncreasing_comp : forall {B B'} (I : BSmgIso B B'), RightStrictIncreasing_comp B -> RightStrictIncreasing_comp B'.
   Proof. intros B B' I; LatticePropsIso B I. Defined.

   Ltac IdPropsIso B iso :=
      let h := fresh "h" in
      let h' := fresh "h" in
      let hasId := fresh "hasId" in
      let hasId' := fresh "hasId" in
      intros h hasId';
      assert (HasIdentity (plusSmg B)) as hasId; [ propIso hasId' iso false |];
      assert (h' := h hasId);
      propIso h' iso true.

   Lemma Iso_IsRightTimesMapToIdConstantPlus : forall {B B'} (I : BSmgIso B B'), IsRightTimesMapToIdConstantPlus B -> IsRightTimesMapToIdConstantPlus B'.
   Proof. intros B B' I; IdPropsIso B I.
      rewrite (Iso_PresId' (plusSmgBSmgIso I) hasId hasId0) in h0; auto.
   Defined.

   Lemma Iso_IsRightTimesMapToIdConstantPlus_comp : forall {B B'} (I : BSmgIso B B'), IsRightTimesMapToIdConstantPlus_comp B -> IsRightTimesMapToIdConstantPlus_comp B'.
   Proof. intros B B' I; IdPropsIso B I.
      rewrite (Iso_PresId (plusSmgBSmgIso I) hasId hasId0) in h; auto.
   Defined.

   Lemma Iso_IsLeftTimesMapToIdConstantPlus : forall {B B'} (I : BSmgIso B B'), IsLeftTimesMapToIdConstantPlus B -> IsLeftTimesMapToIdConstantPlus B'.
   Proof. intros B B' I; IdPropsIso B I. 
      rewrite (Iso_PresId' (plusSmgBSmgIso I) hasId hasId0) in h0; auto.
   Defined.

   Lemma Iso_IsLeftTimesMapToIdConstantPlus_comp : forall {B B'} (I : BSmgIso B B'), IsLeftTimesMapToIdConstantPlus_comp B -> IsLeftTimesMapToIdConstantPlus_comp B'.
   Proof. intros B B' I; IdPropsIso B I.
      rewrite (Iso_PresId (plusSmgBSmgIso I) hasId hasId0) in h; auto.
   Defined.

   Lemma Iso_PlusIdentityIsTimesLeftAnnihilator : forall {B B'} (I : BSmgIso B B'), PlusIdentityIsTimesLeftAnnihilator B -> PlusIdentityIsTimesLeftAnnihilator B'.
   Proof. intros B B' I; IdPropsIso B I.
      rewrite (Iso_PresId' (plusSmgBSmgIso I) hasId hasId0) in h0; auto.
   Defined.

   Lemma Iso_PlusIdentityIsTimesLeftAnnihilator_comp : forall {B B'} (I : BSmgIso B B'), PlusIdentityIsTimesLeftAnnihilator_comp B -> PlusIdentityIsTimesLeftAnnihilator_comp B'.
   Proof. intros B B' I; IdPropsIso B I.
      rewrite (Iso_PresId (plusSmgBSmgIso I) hasId hasId0) in h; auto.
   Defined.

   Lemma Iso_PlusIdentityIsTimesRightAnnihilator : forall {B B'} (I : BSmgIso B B'), PlusIdentityIsTimesRightAnnihilator B -> PlusIdentityIsTimesRightAnnihilator B'.
   Proof. intros B B' I; IdPropsIso B I.
      rewrite (Iso_PresId' (plusSmgBSmgIso I) hasId hasId0) in h0; auto.
   Defined.

   Lemma Iso_PlusIdentityIsTimesRightAnnihilator_comp : forall {B B'} (I : BSmgIso B B'), PlusIdentityIsTimesRightAnnihilator_comp B -> PlusIdentityIsTimesRightAnnihilator_comp B'.
   Proof. intros B B' I; IdPropsIso B I.
      rewrite (Iso_PresId (plusSmgBSmgIso I) hasId hasId0) in h; auto.
   Defined.

End BisemigroupIso.


(* Some implicit structure between properties that will simplify things later *)

   Lemma comm_distr : forall B : Bisemigroup, IsCommutative (timesSmg B) -> IsLeftDistributive B -> IsRightDistributive B.
   Proof. intros B comm ld x y z;
      assert (forall x y, times B x y == times B y x) as comm'; [ apply comm |].
      rewrite (comm' (plus B x y)), (comm x z), (comm y z).
      apply ld.
   Defined.

   Lemma comm_distr_comp : forall B : Bisemigroup, 
      IsCommutative (timesSmg B) -> IsLeftDistributive_comp B -> IsRightDistributive_comp B.
   Proof. intros B comm [x [y [z ld]]]; exists x; exists y; exists z.
      toProp; intros h; elim ld; clear ld; dseq_f.
      assert (forall x y, times B x y == times B y x) as comm'; [ apply comm |].
      rewrite (comm' z (plus B x y)), (comm z x), (comm z y); apply h.
   Defined.

(*
   
   Lemma comm_codistr : forall B : Bisemigroup, IsCommutative (plusSmg B) -> IsLeftCoDistributive B -> IsRightCoDistributive B.
   Proof. intros B comm ld x y z;
      assert (forall x y, plus B x y == plus B y x) as comm'; [ apply comm |].
      rewrite (comm' (times B x y)), (comm x z), (comm y z).
      apply ld.
   Defined.

   Lemma comm_codistr_comp : forall B : Bisemigroup, 
      IsCommutative (plusSmg B) -> IsLeftCoDistributive_comp B -> IsRightCoDistributive_comp B.
   Proof. intros B comm [x [y [z ld]]]; exists x; exists y; exists z.
      toProp; intros h; elim ld; clear ld; dseq_f.
      assert (forall x y, plus B x y == plus B y x) as comm'; [ apply comm |].
      rewrite (comm' z (times B x y)), (comm z x), (comm z y); apply h.
   Defined.

*)