Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.IdArrow.
Require Import Metarouting.Logic.Logic.

Section Glue.

   (* experimental *)
   Definition glueBSmg_bad : forall (A B : Semigroup), Semigroup.setoid A = Semigroup.setoid B -> Bisemigroup.
      intros A B e.
      assert (q := fun plus plus_assoc plus_pres_eq => 
              @Build_Bisemigroup 
              (@Build_DecSetoid B (choose B) (@equal B) (refl B) (sym B) (trans B))
              plus
              (Semigroup.op B)
              plus_assoc
              plus_pres_eq
              (Semigroup.assoc B)
              (Semigroup.op_pres_eq B)
            ).
      rewrite <- e in *.
      apply (q (Semigroup.op A) 
               (Semigroup.assoc A) 
               (Semigroup.op_pres_eq A)).
   Defined.
(*
   Definition glueBSmg : forall (A B : Semigroup), DsEq A B -> Bisemigroup.
     intros A B e. (*unfold DsEq in *.*)
     assert (q := fun plus plus_assoc plus_pres_eq => 
              @Build_Bisemigroup
              (*(@Build_DecSetoid B (choose B) (@equal B) (refl B) (sym B) (trans B))*)
              B
              plus
              (Semigroup.op B)
              plus_assoc
              plus_pres_eq
              (Semigroup.assoc B)
              (Semigroup.op_pres_eq B)
            ).
     simpl in q.
     destruct e.
     apply (q (Semigroup.op A) 
              (Semigroup.assoc A) 
              (Semigroup.op_pres_eq A)).
   Defined.*)
   
   Definition glueBSmg (A B : Semigroup) (e : DsEq A B) : Bisemigroup :=
      let halfDef :=
         fun (plus : B -> B -> B) 
             (plus_assoc : Associative plus) 
             (plus_pres_eq : Preserves plus) =>
             Build_Bisemigroup plus_assoc plus_pres_eq (assoc B) (op_pres_eq B)
      in
      match e in (DsEq _ d) 
      return ((forall plus : d -> d -> d, Associative plus -> Preserves plus -> Bisemigroup) -> Bisemigroup)
      with
      | dsEq_refl => fun hDef => hDef (op A) (assoc A) (op_pres_eq A)
      end halfDef.

   Lemma glueBSmg_IdSmgIso_plus : forall A B e, IdSmgIso (plusSmg (glueBSmg A B e)) A.
      intros.
      destruct A; destruct B; simpl in *.
      destruct e.
      unfold plusSmg; simpl in *; auto.
(*      destruct A; destruct setoid;
      destruct B; destruct setoid;
      unfold DsEq in e; simpl in *; destruct e.
      unfold plusSmg; simpl; auto. *)
   Defined.

   Lemma glueBSmg_IdSmgIso_times : forall A B e, IdSmgIso (timesSmg (glueBSmg A B e)) B.
      intros.
      destruct A; destruct B; simpl in *; destruct e.
(*      destruct A; destruct setoid;
      destruct B; destruct setoid;
      unfold DsEq in e; simpl in *; destruct e. *)
      unfold plusSmg; simpl; auto.
   Defined.

(*
   Lemma glue_the_same : 
      forall (A B : Semigroup) e, Exists x : DsEq A B, setoid (glueBSmg A B x) = setoid (glueBSmg_bad A B e).
   Proof. intros.
      split with (eq_DsEQ A B e).
      destruct A; destruct B; simpl in *.
      destruct e.
      unfold eq_DsEQ; simpl.
      destruct setoid; destruct setoid0; simpl in *.


   (* experimental - here!!! right here is the place where we get ill-typed expressions *)

   Definition plusBSmgIso_bad : forall A B e, SmgIso A (plusSmg (glueBSmg_bad A B e)).
   Proof. intros A B e.
      destruct A; destruct B; simpl in *.
      rewrite e.


      unfold DsEq in e; simpl in *.
      destruct setoid; destruct setoid0; simpl in *.
      unfold DsEq in q. simpl in *. destruct q.
      
      unfold glueBSmg_bad. simpl. unfold eq_rect_r; simpl.
      unfold eq_rect; simpl.
      unfold sym_eq; simpl.
      
      destruct e.
      

      injection e. intros.
      destruct e; simpl in *.
      unfold plusSmg; simpl.
   Defined.
*)
   
   Definition plusBSmgIso : forall A B e, SmgIso A (plusSmg (glueBSmg A B e)).
   Proof. intros A B e. destruct A; destruct B; simpl in *.
      destruct e; unfold plusSmg; simpl in *; auto.
      (*unfold DsEq in e; simpl in *.
      destruct setoid; destruct setoid0; simpl in *.
      unfold glueBSmg; simpl.
      unfold plusSmg; simpl.
      destruct e; simpl in *.
      unfold plusSmg; simpl.*)
      apply SmgIso_refl.
   Defined.
   
   Definition timesBSmgIso : forall A B e, SmgIso B (timesSmg (glueBSmg A B e)).
   Proof. intros A0 B0 e. destruct A0; destruct B0; simpl in *.
      destruct e.
      (*unfold DsEq in e; simpl in *.
      destruct setoid; destruct setoid0; simpl in *.
      destruct e. simpl in *.*)
      unfold timesSmg; simpl.
      apply SmgIso_refl.
   Defined.

   Definition projPlusBSmgIso : forall A B e, sgProp A -> sgProp (plusSmg (glueBSmg A B e)).
      intros A B e h; apply (sgPropIso (plusBSmgIso A B e) h).
   Defined.

   Definition projTimesBSmgIso : forall A B e, sgProp B -> sgProp (timesSmg (glueBSmg A B e)).
      intros A B e h; apply (sgPropIso (timesBSmgIso A B e) h).
   Defined.

End Glue.