
(* TO BE REMOVED *)
(*

Require Import Metarouting.Logic.Logic.

(*********************************************************************)
(* Relations *)

Section RelationsAndProperties.

   (* implicit argument on which relations and there properties will *)
   (* be defined *)
   Variable A : Type.

   Definition Rel :=
      A -> A -> Prop.

   (* this allows using R as implicit agrument in the following definitions *)
   Variable R : Rel. 

   (* properties of relations *)
   Definition Reflexive := 
      forall (x : A), R x x.

   Definition Symmetric :=
      forall (x y : A), R x y -> R y x.

   Definition Transitive :=
      forall (x y z : A), R x y -> R y z -> R x z.

   (* what sort of equality is this ??? what about setoids ??? *)
   Definition Antisymmetric (eq : A -> A -> Prop) :=
      forall (x y : A), R x y -> R y x -> eq x y.

   Structure Equivalence : Type := 
   {
      refl   : Reflexive;
      sym    : Symmetric;
      trans  : Transitive 
   }.

   (* bridge Prop with Set *)
   Inductive Dec (P : Prop) : Set :=
      | yes : P -> Dec P
      | no  : Not P -> Dec P.

   Definition Decidable : Type :=
      forall (x y : A), Dec (R x y).

   (**********************************************************************)
   (* define equational reasoning *)
   Variable Eq : Equivalence.

   Inductive IsRelatedTo (x y : A) : Type :=
      relTo : R x y -> IsRelatedTo x y.

   Lemma eqReason : forall x y z : A, R x y -> R y z -> R x z.
   Proof.
      intros x y z a b.
      apply (trans Eq x y z a b).
   Defined.


End RelationsAndProperties.

Hint Unfold Reflexive Transitive Antisymmetric Symmetric.
Hint Resolve Build_Equivalence.

*)