Require Import Metarouting.Language.Summary.
Require Import Coq.Lists.List. 
Open Scope list_scope. 
Open Scope string_scope.

(**************************************************)
(*               Main two examples                *)
(**************************************************)

(* Require Import Coq.Strings.String. *)
(* Open Scope string_scope. *)

Open Scope Exp_scope.

(* OK *) Definition E1 := bSelLex bNatMinPlus bNatMaxMin.
(* OK *) Definition E2 := bSelLex bNatMaxMin bNatMinPlus.
(* OK *) Definition E3 := bAddOne bNatMaxMin.
(* OK *) Definition E4 := bAddZero bNatMinPlus.
(* OK *) Definition E5 := bAddZero ( bAddOne ( bSelLex bNatMinPlus bNatMaxMin ) ).
(* ER *) Definition E6 := bSelLex ( bAddZero bNatMinPlus ) ( bAddOne bNatMaxMin ).
(* OK *) Definition E7 := bAddZero ( bSelLex bNatMinPlus ( bLeft ( sFSetsUnion dNat ) ) ).
(* ER *) Definition E8 := bAddZero ( bLex ( bProduct bNatMinPlus bNatMinPlus ) ( bAddZero ( bLeft ( sFSetsUnion dNat ) ) ) ).
(* OK *) Definition E9 := bAddZero ( bSelLex ( bNatMinPlus ) ( bFSetsOp ( sSeq ( dNat ) ) ) ).

Definition E1S := expInfo (expBS E1).
Definition E2S := expInfo (expBS E2).
Definition E3S := expInfo (expBS E3).
Definition E4S := expInfo (expBS E4).
Definition E5S := expInfo (expBS E5).
Definition E6S := expInfo (expBS E6).
Definition E7S := expInfo (expBS E7).
Definition E8S := expInfo (expBS E8).
Definition E9S := expInfo (expBS E9).

Ltac id x := x.

Ltac showDsInfo y :=
   let y := (eval hnf in y) in

   idtac "------------------ DS Props ------------------";

   let p := id (takeValue (iIsSingleton y)) in let p := (eval hnf in p) in
   idtac "iIsSingleton" p;

   let p := id (takeValue (iTwoElements y)) in let p := (eval hnf in p) in
   idtac "iTwoElements" p;

   let p := id (takeValue (iFinite y)) in let p := (eval hnf in p) in
   idtac "iFinite" p.

Ltac showSgInfo y :=
   let y := (eval hnf in y) in

   showDsInfo (iSg_dsprop y);

   idtac "------------------ SG Props ------------------";

   let p := id (takeValue (iHasIdentity y)) in let p := (eval hnf in p) in
   idtac "iHasIdentity" p;

   let p := id (takeValue (iHasAnnihilator y)) in let p := (eval hnf in p) in
   idtac "iHasAnnihilator" p;

   let p := id (takeValue (iIsSelective y)) in let p := (eval hnf in p) in
   idtac "iIsSelective" p;

   let p := id (takeValue (iIsCommutative y)) in let p := (eval hnf in p) in
   idtac "iIsCommutative" p;

   let p := id (takeValue (iIsIdempotent y)) in let p := (eval hnf in p) in
   idtac "iIsIdempotent" p;

   let p := id (takeValue (iIsLeft y)) in let p := (eval hnf in p) in
   idtac "iIsLeft" p;

   let p := id (takeValue (iIsRight y)) in let p := (eval hnf in p) in
   idtac "iIsRight" p;

   let p := id (takeValue (iSg_leftCondensed y)) in let p := (eval hnf in p) in
   idtac "iSg_leftCondensed" p;

   let p := id (takeValue (iSg_rightCondensed y)) in let p := (eval hnf in p) in
   idtac "iSg_rightCondensed" p;

   let p := id (takeValue (iSg_LeftCancelative y)) in let p := (eval hnf in p) in
   idtac "iSg_LeftCancelative" p;

   let p := id (takeValue (iSg_RightCancelative y)) in let p := (eval hnf in p) in
   idtac "iSg_RightCancelative" p.

Ltac showBsInfo y :=
   let y := (eval hnf in y) in

   showSgInfo (iBs_plus_sgprop y);
   showSgInfo (iBs_times_sgprop y);
   
   idtac "------------------ BS Props ------------------";

   let p := id (takeValue (iIsLeftDistributive y)) in let p := (eval hnf in p) in
   idtac "iIsLeftDistrivutive" p;

   let p := id (takeValue (iIsRightDistributive y)) in let p := (eval hnf in p) in
   idtac "iIsRightDistributive" p;
   
   let p := id (takeValue (iIsLeftCoDistributive y)) in let p := (eval hnf in p) in
   idtac "iIsLeftCoDistributive" p;
   
   let p := id (takeValue (iIsRightCoDistributive y)) in let p := (eval hnf in p) in
   idtac "iIsRightCoDistributive" p;
   
   let p := id (takeValue (iPlusIdentityIsTimesAnnihilator y)) in let p := (eval hnf in p) in
   idtac "iPlusIdentityIsTimesAnnihilator" p;
   
   let p := id (takeValue (iPlusAnnihilatorIsTimesIdentity y)) in let p := (eval hnf in p) in
   idtac "iPlusAnnihilatorIsTimesIdentity" p;
   
   let p := id (takeValue (iIsLeftStrictStable y)) in let p := (eval hnf in p) in
   idtac "iIsLeftStrictStable" p;
   
   let p := id (takeValue (iIsRightStrictStable y)) in let p := (eval hnf in p) in
   idtac "iIsRightStrictStable" p;
   
   let p := id (takeValue (iIsLeftCompEqCancel y)) in let p := (eval hnf in p) in
   idtac "iIsLeftCompEqCancel" p;
   
   let p := id (takeValue (iIsRightCompEqCancel y)) in let p := (eval hnf in p) in
   idtac "iIsRightCompEqCancel" p;

   let p := id (takeValue (iIsLeftCompCancel y)) in let p := (eval hnf in p) in
   idtac "iIsLeftCompCancel" p;
   
   let p := id (takeValue (iIsRightCompCancel y)) in let p := (eval hnf in p) in
   idtac "iIsRightCompCancel" p;
   
   let p := id (takeValue (iLeftDiscrete y)) in let p := (eval hnf in p) in
   idtac "iLeftDiscrete" p;
   
   let p := id (takeValue (iRightDiscrete y)) in let p := (eval hnf in p) in
   idtac "iRightDiscrete" p;
   
   let p := id (takeValue (iLeftComparable y)) in let p := (eval hnf in p) in
   idtac "iLeftComparable" p;
   
   let p := id (takeValue (iRightComparable y)) in let p := (eval hnf in p) in
   idtac "iRightComparable" p;
   
   let p := id (takeValue (iLeftIncreasing y)) in let p := (eval hnf in p) in
   idtac "iLeftIncreasing" p;
   
   let p := id (takeValue (iRightIncreasing y)) in let p := (eval hnf in p) in
   idtac "iRightIncreasing" p;
   
   let p := id (takeValue (iLeftStrictIncreasing y)) in let p := (eval hnf in p) in
   idtac "iLeftStrictIncreasing" p;
   
   let p := id (takeValue (iRightStrictIncreasing y)) in let p := (eval hnf in p) in
   idtac "iRightStrictIncreasing" p;
   
   let p := id (takeValue (iIsLeftTimesMapToIdConstantPlus y)) in let p := (eval hnf in p) in
   idtac "iIsLeftTimesMapToIdConstantPlus" p;
   
   let p := id (takeValue (iIsRightTimesMapToIdConstantPlus y)) in let p := (eval hnf in p) in
   idtac "iIsRightTimesMapToIdConstantPlus" p;
   
   let p := id (takeValue (iPlusIdentityIsTimesLeftAnnihilator y)) in let p := (eval hnf in p) in
   idtac "iPlusIdentityIsTimesLeftAnnihilator" p;
   
   let p := id (takeValue (iPlusIdentityIsTimesRightAnnihilator y)) in let p := (eval hnf in p) in
   idtac "iPlusIdentityIsTimesRightAnnihilator" p.

Ltac bInfo v :=
   let v := (eval compute in v) in
   idtac "Syntax: " v;
   let v := (eval hnf in (expInfo (expBS v))) in
   match v with
      | Some ?x => 
         let x := (eval hnf in x) in
         match x with
            | existT _ _ ?y => showBsInfo y
         end
      | None => idtac "No semantics!!!"
   end;
   idtac " ";
   idtac " ";
   idtac " ";
   idtac " ".



Ltac showSlideInfo y :=
   idtac "------------------ Slide Props ------------------";
   (* EZ *)
   let p := id (takeValue (iHasIdentity (iBs_plus_sgprop y))) in 
   let v := (eval red in p) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in p) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   let v := (eval red in v) in
   (* OK *)
   (* let v := (eval red in v) in *)
   (* FAIL *)
   idtac "EZ" v.

Ltac bSlideInfo v :=
   let v := (eval compute in v) in
   idtac "Syntax: " v;
   let v := (eval hnf in (expInfo (expBS v))) in
   match v with
      | Some ?x => 
         let x := (eval hnf in x) in
         match x with
            | existT _ _ ?y => showSlideInfo y
         end
      | None => idtac "No semantics!!!"
   end;
   idtac " ";
   idtac " ";
   idtac " ";
   idtac " ".

Lemma print_example_info : True.
Proof.

   bSlideInfo E5.

(*   bInfo E1.
   bInfo E2.
   bInfo E3.
   bInfo E4.
   bInfo E5.
   bInfo E6.
   bInfo E7.
   bInfo E8.
   bInfo E9.*)
   
   auto.
Qed.





(*
   idtac v.

Eval lazy in E1S.

(* Martelli cut-sets *)
Definition cut_set_algebra := bsDual @ (bsFMinSets @ (osRightNaturalOrder @ (sgFSetsUnion @ dsNat))).

(* Bottleneck *)
Definition bottleneck_algebra := bsFMinSets @ (osRightNaturalOrder @ (sgFMinSetsUnion @ (psDual @ psNatLe))).

Eval hnf in expSummary cut_set_algebra.
Eval hnf in expSummary bottleneck_algebra.

Definition option_fn {A B} (f : A -> B) (x : option A) : option B :=
   match x with
      | Some x => Some (f x)
      | None => None
   end.

Definition option_dfn {A} {B : A -> Type} (f : forall x, B x) (x : option A) : 
   match x with Some x => B x | None => unit end :=
   match x with
      | Some x => f x
      | None => tt
   end.

Definition sigma_fn {T} {A B : T -> Type} (f : forall x, A x -> B x) (y : Ex _ A) : Ex _ B :=
   match y with
      | sigma x p => sigma _ _ x (f x p)
   end.

Implicit Arguments sigma [A P].

Lemma test : True.
   set (x := match (bsInfo bottleneck_algebra) return option (Exists T wt, Witnesses T wt) with
               | Some (sigma T bsi) => Some (sigma _ (sigma _ (iIsLeftDistributive bsi)))
               | None => None
            end).
   hnf in x.
   copy_destruct x. unfold x in *.
   assert (h := sym_eq ew).
   injection h as p.
   let t := value of x in
   match t with
      | Some ?y => set (a := y)
   end.

Eval hnf in match (bsInfo bottleneck_algebra) return option (Exists T wt, Witnesses T wt) with
               | Some (sigma T bsi) => Some (sigma _ (sigma _ (iIsLeftDistributive bsi)))
               | None => None
            end.

Eval hnf in option_fn (@iIsLeftDistributive _) (option_fn eproj2 (bsInfo cut_set_algebra)).

(*
Definition bottleneck_algebra2 := Fun Pos _ (bsFMinSets @ (osRightNaturalOrder @ (sgFMinSetsUnion @ (psDual @ (Var Pos 0))))).

Definition opLift {X} {Y} (f : X -> Y) : X -> option Y := fun x => Some (f x).

Definition opdLift {X} {Y : X -> Type} (f : forall x : X, Y x) (x : X) : option (Y x) := Some (f x).

Definition test_algebra := sgLex @ sgIntMax @ sgIntPlus.

Definition take_identity :=
   (eSem test_algebra)
   >>=d (fun s => (hasIdentity _ (eproj2 s)))
   >>= (opLift eproj1).

Eval lazy in take_identity.

Definition take_op :=
  (eSem test_algebra)
   >>= (fun x => Some (eproj1 x))
   >>=d (fun x => Some (op x)).


Eval lazy in take_op.

Lemma t : True.
Proof.
   set (x := take_op).
   hnf in (value of x).
   unfold Lex.lexSemigroup in (value of x).
   simpl in (value of x).
   unfold Lex.lexOp in (value of x).

Definition take_identity :=
  (eSem cut_set_algebra)
   >>=d (fun s => (hasIdentity _ (bs_plus_sgprop _ (eproj2 s))))
   >>= (opLift eproj1)
   >>= (opLift eproj1). (* this is neededto hide the proof *)

Eval lazy in take_identity.

Definition take_op :=
  (eSem cut_set_algebra)
   >>= (fun x => Some (eproj1 x))
   >>=d (fun x => Some (plus x)).

Lemma t : True.
Proof.
   set (x := take_op).
   hnf in (value of x).
   simpl in (value of x).
   unfold FMinSetsOp.minset_op in (value of x).
   unfold FMinSets.min' in (value of x).
   unfold FMinSets.ignore_min in (value of x).
   unfold FSetOp.fset_op in (value of x).
   simpl in (value of x).
   unfold FMinSets.min in (value of x).
   unfold FMinSets.minimal_el in (value of x).
*)
*)
