Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Language.Syntax.
Require Import Metarouting.Language.Semantics.
Require Import Metarouting.Language.OcamlTypes.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformProperties.
Require Import Metarouting.Language.AstDS.

(*********************************************************************)
(*                            Transforms                             *)
(*********************************************************************)

Section BuildIsoTransform.
   Set Implicit Arguments.
   Open Scope Transform_scope.

   (** 
     * Build a decidable setoid from type split mono f.
     *)
   Variable S : Transform.
   Variable T Q : Type.
   Variable smono : splitMono S T.
   Variable fnsmono : splitMono (fn S) Q.
   Local Notation f := (mono smono).
   Local Notation f' := (mono_inv smono).
   Local Notation g := (mono fnsmono).
   Local Notation g' := (mono_inv fnsmono).

   (**
     * Lift algebraic structure
     *)
   Definition app_T (a : buildIsoDs (fn S) fnsmono) (b : buildIsoDs S smono) : buildIsoDs S smono := 
      f ((g' a) |> (f' b)).
   
   Lemma app_T_pres_eq : AppPreserve app_T.
   Proof. intros x y u v. unfold dseq; simpl; unfold app_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono).
      apply app_pres_eq.
   Qed.
      
   Definition buildIsoTf : Transform :=
      Build_Transform
         app_T_pres_eq.

   Definition buildIsoTf_Iso : TfIso S buildIsoTf.
      split with (buildIsoDs_Iso S smono) (buildIsoDs_Iso (fn S) fnsmono).
      split.
      intros x y; unfold dseq; simpl; unfold app_T, eq_T; simpl; dseq_f; 
         repeat rewrite (mono_spec smono); repeat rewrite (mono_spec fnsmono); auto.
      intros x y; unfold dseq; simpl; unfold app_T, eq_T; simpl; dseq_f; 
         repeat rewrite (mono_spec smono); repeat rewrite (mono_spec fnsmono); auto.
   Defined.

End BuildIsoTransform.

Section OcamlTF.
   Set Implicit Arguments.

   Definition astTF (x : Transform) 
      t (e : ocmType t = carrier x) 
      fnt (e' : ocmType fnt = carrier (fn x)) 
      : Exists y, TfIso x y.
      intros.
      assert (h := @astSplitMono t).
      assert (h' := @astSplitMono fnt).
      rewrite e in h.
      rewrite e' in h'.
      exists (buildIsoTf x h h').
      apply buildIsoTf_Iso.
   Defined.
   
End OcamlTF.