Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Language.Syntax.
Require Import Metarouting.Language.Semantics.
Require Import Metarouting.Language.OcamlTypes.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformProperties.
Require Import Metarouting.Language.AstDS.


Section BuildIsoSemigroupTransform.
   Set Implicit Arguments.
   Open Scope SemigroupTransform_scope.

   (** 
     * Build a decidable setoid from type split mono f.
     *)
   Variable S : SemigroupTransform.
   Variable T Q : Type.
   Variable smono : splitMono S T.
   Variable fnsmono : splitMono (fn S) Q.
   Local Notation f := (mono smono).
   Local Notation f' := (mono_inv smono).
   Local Notation g := (mono fnsmono).
   Local Notation g' := (mono_inv fnsmono).

   (**
     * Lift algebraic structure
     *)
   Definition op_T (a b : buildIsoDs S smono) : buildIsoDs S smono := 
      f ((f' a) + (f' b)).
   
   Lemma op_T_assoc : Associative op_T.
   Proof. intros x y z. unfold dseq; simpl; unfold op_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono). apply assoc.
   Qed.
   
   Lemma op_T_pres_eq : Preserves op_T.
   Proof. intros x y u v; unfold dseq; simpl; unfold op_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono); apply op_pres_eq.
   Qed.

   Definition app_T (a : buildIsoDs (fn S) fnsmono) (b : buildIsoDs S smono) : buildIsoDs S smono := 
      f ((g' a) |> (f' b)).
   
   Lemma app_T_pres_eq : AppPreserve app_T.
   Proof. intros x y u v. unfold dseq; simpl; unfold app_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono).
      apply app_pres_eq.
   Qed.
      
   Definition buildIsoSTf : SemigroupTransform :=
      Build_SemigroupTransform
         op_T_assoc
         op_T_pres_eq
         app_T_pres_eq.

   Definition buildIsoSTf_Iso : STfIso S buildIsoSTf.
      split with (buildIsoDs_Iso S smono) (buildIsoDs_Iso (fn S) fnsmono).
      split.
      intros x y; unfold dseq; simpl; unfold op_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
      intros x y; unfold dseq; simpl; unfold op_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.

      intros x y; unfold dseq; simpl; unfold app_T, eq_T; simpl; dseq_f; 
         repeat rewrite (mono_spec smono); repeat rewrite (mono_spec fnsmono); auto.
      intros x y; unfold dseq; simpl; unfold app_T, eq_T; simpl; dseq_f; 
         repeat rewrite (mono_spec smono); repeat rewrite (mono_spec fnsmono); auto.
   Defined.

End BuildIsoSemigroupTransform.

Section OcamlST.
   Set Implicit Arguments.

   Definition astST (x : SemigroupTransform) 
      t (e : ocmType t = carrier x) 
      fnt (e' : ocmType fnt = carrier (fn x)) 
      : Exists y, STfIso x y.
      intros.
      assert (h := @astSplitMono t).
      assert (h' := @astSplitMono fnt).
      rewrite e in h.
      rewrite e' in h'.
      exists (buildIsoSTf x h h').
      apply buildIsoSTf_Iso.
   Defined.
   
End OcamlST.