Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Language.Syntax.
Require Import Metarouting.Language.Semantics.
Require Import Metarouting.Language.OcamlTypes.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Language.AstDS.

(*********************************************************************)
(*                            Semigroups                             *)
(*********************************************************************)

Section BuildIsoSemigroup.
   Set Implicit Arguments.
   Open Scope Semigroup_scope.

   (** 
     * Build a decidable setoid from type split mono f.
     *)
   Variable S : Semigroup.
   Variable T : Type.
   Variable smono : splitMono S T.
   Local Notation f := (mono smono).
   Local Notation f' := (mono_inv smono).

   (**
     * Lift algebraic structure
     *)
   Definition op_T (a b : buildIsoDs S smono) : buildIsoDs S smono := 
      f ((f' a) + (f' b)).
   
   Lemma op_T_assoc : Associative op_T.
   Proof. intros x y z. unfold dseq; simpl; unfold op_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono). apply assoc.
   Qed.
   
   Lemma op_T_pres_eq : Preserves op_T.
   Proof. intros x y u v; unfold dseq; simpl; unfold op_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono); apply op_pres_eq.
   Qed.
   
   Definition buildIsoSmg : Semigroup :=
      Build_Semigroup
         op_T_assoc
         op_T_pres_eq.

   Definition buildIsoSmg_Iso : SmgIso S buildIsoSmg.
      apply (@Build_SmgIso S buildIsoSmg (buildIsoDs_Iso S smono)).
      apply Build_IsSmgIso.
      intros x y; unfold dseq; simpl; unfold op_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
      intros x y; unfold dseq; simpl; unfold op_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
   Defined.

(*
   Definition astSemigroupSem : SemigroupSem :=
      existT _ buildIsoSmg (sgPropIso buildIsoSmg_Iso (projT2 S)).
*)

End BuildIsoSemigroup.

Section OcamlSG.
   Set Implicit Arguments.

   Definition astSG (x : Semigroup) t (e : ocmType t = carrier x) : Exists y, SmgIso x y.
      intros.
      assert (h := @astSplitMono t).
      rewrite e in h.
      exists (buildIsoSmg x h).
      apply buildIsoSmg_Iso.
   Defined.
   
(*
   Definition astSmgSem (sm : SemigroupSem) t (e : ocmType t = carrier sm) : SemigroupSem.
      intros. apply (@astSemigroupSem sm (wfAst t)).
      rewrite <- e. apply astSplitMono.
   Defined.
   
   Definition astSG (sg : SG) : SemigroupSem + NotWF.
      intros sg.
      assert (ot := otSG_correct sg); red in ot.
      destruct (semSG sg).
      apply inl; apply (astSmgSem s (otSG sg)); destruct s; simpl in *; rewrite <- ot; auto.
      apply inr; apply n.
   Defined.
*)
   
End OcamlSG.