Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.
Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Language.Syntax.
Require Import Metarouting.Language.Semantics.
Require Import Metarouting.Language.OcamlTypes.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.BisemigroupProperties.
Require Import Metarouting.Language.AstDS.


(*********************************************************************)
(*                           Bisemigroups                            *)
(*********************************************************************)

Section BuildIsoBisemigroup.
   Set Implicit Arguments.
   Open Scope Bisemigroup_scope.

   (** 
     * Build a decidable setoid from type split mono f.
     *)
   Variable B : Bisemigroup.
   Variable T : Type.
   Variable smono : splitMono B T.
   Local Notation f := (mono smono).
   Local Notation f' := (mono_inv smono).

   (**
     * Lift algebraic structure
     *)
   Definition plus_T (a b : buildIsoDs (plusSmg B) smono) : buildIsoDs (plusSmg B) smono := 
      f ((f' a) + (f' b)).
   Definition times_T (a b : buildIsoDs (timesSmg B) smono) : buildIsoDs (timesSmg B) smono := 
      f ((f' a) * (f' b)).
   
   Lemma plus_T_assoc : Associative plus_T.
   Proof. intros x y z. unfold dseq; simpl; unfold plus_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono). apply plus_assoc.
   Qed.

   Lemma plus_T_pres_eq : Preserves plus_T.
   Proof. intros x y u v; unfold dseq; simpl; unfold plus_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono). apply plus_pres_eq.
   Qed.

   Lemma times_T_assoc : Associative times_T.
   Proof. intros x y z. unfold dseq; simpl; unfold times_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono). apply times_assoc.
   Qed.

   Lemma times_T_pres_eq : Preserves times_T.
   Proof. intros x y u v; unfold dseq; simpl; unfold times_T, eq_T; simpl; dseq_f.
      repeat rewrite (mono_spec smono). apply times_pres_eq.
   Qed.

   Definition buildIsoBSmg : Bisemigroup :=   
      Build_Bisemigroup
         plus_T_assoc
         plus_T_pres_eq
         times_T_assoc
         times_T_pres_eq.

   Definition buildIsoBSmg_Iso : BSmgIso B buildIsoBSmg.
      apply (@Build_BSmgIso B buildIsoBSmg (buildIsoDs_Iso (plusSmg B) smono)).
      apply Build_IsBSmgIso.
      intros x y; unfold dseq; simpl; unfold plus_T, times_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
      intros x y; unfold dseq; simpl; unfold plus_T, times_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
      intros x y; unfold dseq; simpl; unfold plus_T, times_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
      intros x y; unfold dseq; simpl; unfold plus_T, times_T, eq_T; simpl; dseq_f; repeat rewrite (mono_spec smono); auto.
   Defined.

(*
   Definition astBisemigroupSem : BisemigroupSem :=
      existT _ buildIsoBSmg (bsPropIso buildIsoBSmg_Iso (projT2 B)).
*)

End BuildIsoBisemigroup.

Section OcamlBS.
   Set Implicit Arguments.
   
   Definition astBS (x : Bisemigroup) t (e : ocmType t = carrier x) : Exists y, BSmgIso x y.
      intros.
      assert (h := @astSplitMono t).
      rewrite e in h.
      exists (buildIsoBSmg x h).
      apply buildIsoBSmg_Iso.
   Defined.

(*   
   Definition astBSmgSem (sm : BisemigroupSem) t (e : ocmType t = carrier sm) : BisemigroupSem.
      intros. apply (@astBisemigroupSem sm (wfAst t)).
      rewrite <- e. apply astSplitMono.
   Defined.
   
   Definition astBS (bs : BS) : BisemigroupSem + NotWF.
      intros bs.
      assert (ot := otBS_correct bs); red in ot.
      destruct (semBS bs).
      apply inl; apply (astBSmgSem b (otBS bs)); destruct b; simpl in *; rewrite <- ot; auto.
      apply inr; apply n.
   Defined.
*)   
End OcamlBS.
