Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Constructions.Transforms.Union.
Require Import Metarouting.IsoPres.DecSetoids.Union.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (A B C D : Transform) (ab : IdDsIso A B) (cd : IdDsIso C D),
      TfIso A C -> TfIso B D ->
         DsIso (unionTransform A B ab) (unionTransform C D cd).
   Proof. intros A B C D ab cd ac bd.
      unfold unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      split with (phi ac) (phi' ac); split; simpl in *.

      intros x y p; rewrite p; auto.
      intros x y p; rewrite p; auto.
      intros x; rewrite (inv ac); auto.
      intros x; rewrite (inv' ac); auto.
   Defined.

   Lemma isoPres_helper_fn : forall (A B C D : Transform) (ab : IdDsIso A B) (cd : IdDsIso C D),
      TfIso A C -> TfIso B D ->
         DsIso (fn (unionTransform A B ab)) (fn (unionTransform C D cd)).
   Proof. intros A B C D ab cd ac bd.
      unfold unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      split with 
      (fun x => match x with inl x => inl _ (phi (fnIso ac) x) | inr x => inr _ (phi (fnIso bd) x) end) 
      (fun x => match x with inl x => inl _ (phi' (fnIso ac) x) | inr x => inr _ (phi' (fnIso bd) x) end);
      split; simpl in *.

      intros [x|x] [y|y] p; dseq_u; simpl in *; auto; dseq_f; rewrite p; auto.
      intros [x|x] [y|y] p; dseq_u; simpl in *; auto; dseq_f; rewrite p; auto.
      intros [x|x]; dseq_u; simpl; auto; dseq_f.
         rewrite (inv (fnIso ac)); auto.
         rewrite (inv (fnIso bd)); auto.
      intros [x|x]; dseq_u; simpl; auto; dseq_f.
         rewrite (inv' (fnIso ac)); auto.
         rewrite (inv' (fnIso bd)); auto.
   Defined.

   Lemma isoPres : forall (A B C D : Transform) (ab : IdDsIso A B) (cd : IdDsIso C D),
      IdTfIso A C -> IdTfIso B D ->
         TfIso (unionTransform A B ab) (unionTransform C D cd).
   Proof. intros A B C D ab cd ac bd.
      set (ds_helper := isoPres_helper A B C D ab cd ac bd).
      set (fn_helper := isoPres_helper_fn A B C D ab cd ac bd).
      unfold unionTransform in *; simpl in *;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *.
      split with ds_helper fn_helper; unfold ds_helper, fn_helper; clear ds_helper fn_helper; simpl in *;
      split; simpl.
      
      intros [f|f] x; simpl; [apply (Transform.pres_app ac)|].
         assert (p := pres_eq ac (pres_eq' ab (pres_eq' bd (Transform.pres_app bd f (phi ab x)))));
         rewrite (inv' bd) in p;  simpl in p.
         destruct ab as [[phi_ab phi_ab'] [ab_id ab_id']]; simpl in *.
            destruct ab_id as [phi_ab phi_ab_eq]; simpl in *.
            assert (phi_ab_eq' := IsId_ext_eq _ ab_id').
            rewrite phi_ab_eq, phi_ab_eq' in *; unfold id in *; simpl.
         destruct cd as [[phi_cd phi_cd'] [cd_id cd_id']]; simpl in *.
            destruct cd_id as [phi_cd phi_cd_eq]; simpl in *.
            assert (phi_cd_eq' := IsId_ext_eq _ cd_id').
            rewrite phi_cd_eq, phi_cd_eq'; unfold id; simpl.
         destruct ac as [[[phi_ac phi_ac'] [fphi_ac fphi_ac']] [ac_id ac_id'][fac_id fac_id']]; simpl in *.
            destruct ac_id as [phi_ac phi_ac_eq]; simpl in *.
            assert (phi_ac_eq' := IsId_ext_eq _ ac_id').
            do 2 rewrite phi_ac_eq in *; unfold id; simpl.
         destruct bd as [[[phi_bd phi_bd'] [fphi_bd fphi_bd']] [bd_id bd_id'][fbd_id fbd_id']]; simpl in *.
            assert (phi_bd_eq := IsId_ext_eq _ bd_id).
            assert (phi_bd_eq' := IsId_ext_eq _ bd_id').
            rewrite phi_bd_eq, phi_bd_eq' in p; unfold id in *; simpl.
            rewrite phi_ab_eq' in p.
         apply p.

      intros [f|f] x; simpl; [apply (Transform.pres_app' ac)|].
         rewrite <- (inv bd (appD f (phi cd x))), (Transform.pres_app' bd f (phi cd x)). simpl.
         destruct ab as [[phi_ab phi_ab'] [ab_id ab_id']]; simpl in *.
            destruct ab_id as [phi_ab phi_ab_eq]; simpl in *.
            assert (phi_ab_eq' := IsId_ext_eq _ ab_id').
            rewrite phi_ab_eq, phi_ab_eq' in *; unfold id in *; simpl.
         destruct cd as [[phi_cd phi_cd'] [cd_id cd_id']]; simpl in *.
            destruct cd_id as [phi_cd phi_cd_eq]; simpl in *.
            assert (phi_cd_eq' := IsId_ext_eq _ cd_id').
            rewrite phi_cd_eq, phi_cd_eq'; unfold id; simpl.
         destruct ac as [[[phi_ac phi_ac'] [fphi_ac fphi_ac']] [ac_id ac_id'][fac_id fac_id']]; simpl in *.
            destruct ac_id as [phi_ac phi_ac_eq]; simpl in *.
            assert (phi_ac_eq' := IsId_ext_eq _ ac_id').
            do 2 rewrite phi_ac_eq' in *; unfold id; simpl.
         destruct bd as [[[phi_bd phi_bd'] [fphi_bd fphi_bd']] [bd_id bd_id'][fbd_id fbd_id']]; simpl in *.
            assert (phi_bd_eq := IsId_ext_eq _ bd_id).
            assert (phi_bd_eq' := IsId_ext_eq _ bd_id').
            rewrite phi_bd_eq, phi_bd_eq'; unfold id in *; simpl; auto.
   Defined.

   Lemma idPres : forall (A B C D : Transform) (ab : IdDsIso A B) (cd : IdDsIso C D),
      IdTfIso A C -> IdTfIso B D ->
         IdTfIso (unionTransform A B ab) (unionTransform C D cd).
   Proof. intros A B C D ab cd ac bd.
      split with (isoPres A B C D ab cd ac bd); split;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *; auto.

      apply ac.

      apply ac.

      destruct ac as [[ac_dsIso [ac_fnphi ac_fnphi']] [] [ac_id ac_id']]; simpl in *;
      destruct bd as [[bd_dsIso [bd_fnphi bd_fnphi']] [] [bd_id bd_id']]; simpl in *.
      clear - ac_id ac_id' bd_id bd_id'.
      destruct ac_id. destruct bd_id. split. intros [x|x]; simpl; unfold id; simpl.
         rewrite (H x); auto.
         rewrite (H0 x); auto.

      destruct ac as [[ac_dsIso [ac_fnphi ac_fnphi']] [] [ac_id ac_id']]; simpl in *;
      destruct bd as [[bd_dsIso [bd_fnphi bd_fnphi']] [] [bd_id bd_id']]; simpl in *.
      clear - ac_id ac_id' bd_id bd_id'.
      destruct ac_id'. destruct bd_id'. split. intros [x|x]; simpl; unfold id; simpl.
         rewrite (H x); auto.
         rewrite (H0 x); auto.
   Defined.

End IsoPres.