Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.Constructions.Semigroups.UnionSwap.
Require Import Metarouting.IsoPres.Semigroups.Union.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres : forall x x' y y', SmgIso x x' -> SmgIso y y' ->
      SmgIso (unionSwapSemigroup x y) (unionSwapSemigroup x' y').
   Proof. intros x x' y y' i i'.
      apply (SmgIso_trans (unionSmgIso x y)).
      apply (SmgIso_trans (Union.isoPres _ _ _ _ i i')).
      apply (SmgIso_sym (unionSmgIso x' y')).
   Defined.

   Lemma idPres : forall x x' y y', IdSmgIso x x' -> IdSmgIso y y' ->
      IdSmgIso (unionSwapSemigroup x y) (unionSwapSemigroup x' y').
   Proof. intros x x' y y' i i'; split with (isoPres x x' y y' i i'); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct i' as [[[phi2 phi2']] [ip2 ip2']]; simpl in *;
      destruct x; destruct x'; destruct y; destruct y'; simpl in *;
      unfold DsIso_trans_phi, DsIso_trans_phi'; simpl.
      
      clear -ip1 ip2; destruct ip1; destruct ip2; split; intros [x|x].
         rewrite (H0 x); auto.
         rewrite (H x); auto.

      clear -ip1' ip2'; destruct ip1'; destruct ip2'; split; intros [x|x].
         rewrite (H0 x); auto.
         rewrite (H x); auto.
   Defined.

End IsoPres.
