Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.IsoPres.DecSetoids.Union.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' y y' : Semigroup), DsIso x x' -> DsIso y y' ->
      DsIso (unionSemigroup x y) (unionSemigroup x' y').
   Proof. intros x x' y y' i i'; destruct x; destruct x'; destruct y; destruct y'; simpl.
      apply Union.isoPres. apply i. apply i'.
   Defined.

   Lemma isoPres : forall x x' y y', SmgIso x x' -> SmgIso y y' ->
      SmgIso (unionSemigroup x y) (unionSemigroup x' y').
   Proof. intros x x' y y' i i'. 
      set (X := x); set (X' := x'); set (ISO := i);
      set (Y := y); set (Y' := y'); set (ISO' := i');
      apply (Build_SmgIso) with (isoPres_helper x x' y y' i i').
      split; simpl; intros [a|a] [b|b]; unfold isoPres_helper; simpl;
      destruct x; destruct x'; destruct i; simpl;
      destruct y; destruct y'; destruct i'; simpl;
      unfold ver_union_op; simpl; dseq_u; simpl; toProp; dseq_f; auto.
      
      apply (pres_op isSmgIso).
      apply (pres_op isSmgIso0).
      apply (pres_op' isSmgIso).
      apply (pres_op' isSmgIso0).
   Defined.

   Lemma idPres : forall x x' y y', IdSmgIso x x' -> IdSmgIso y y' ->
      IdSmgIso (unionSemigroup x y) (unionSemigroup x' y').
   Proof. intros x x' y y' i i';
      split with (isoPres x x' y y' i i'); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct i' as [[[phi2 phi2']] [ip2 ip2']]; simpl in *;
      destruct x; destruct x'; destruct y; destruct y'; simpl in *.
      
      clear -ip1 ip2; destruct ip1; destruct ip2; split; intros [x|x].
         rewrite (H x); auto.
         rewrite (H0 x); auto.

      clear -ip1' ip2'; destruct ip1'; destruct ip2'; split; intros [x|x].
         rewrite (H x); auto.
         rewrite (H0 x); auto.
   Defined.

End IsoPres.
