Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.Semigroups.Prefix.
Require Import Metarouting.IsoPres.DecSetoids.Seq.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section IsoPres.


   Lemma prefix_phi : forall {x x' : DecSetoid} (i : DsIso x x'), 
      forall a b, @dseq (prefixSemigroup x') (map (phi i) (prefix x a b)) (prefix x' (map (phi i) a) (map (phi i) b)).
   Proof. intros x x' i.
      induction a; intros b. auto.
      destruct b as [|w b]; simpl; auto.
      copy_destruct ((a == w)%bool); rewrite ew; simpl.
         assert (phi i a == phi i w) as q1.
            apply (pres_eq i); auto.
         rewrite q1; simpl. dseq_u; simpl. rewrite refl; simpl; auto.
         apply IHa.
         
         assert ((phi i a == phi i w)%bool = false) as q2.
            bool_p; intros h; apply ew; dseq_f.
            rewrite <- (inv' i a), <- (inv' i w); apply (pres_eq' i); auto.
         rewrite q2; simpl; auto.
   Qed.

   Lemma prefix_phi' : forall {x x' : DecSetoid} (i : DsIso x x'), 
      forall a b, @dseq (prefixSemigroup x) (map (phi' i) (prefix x' a b)) (prefix x (map (phi' i) a) (map (phi' i) b)).
   Proof. intros x x' i.
      induction a; intros b. auto.
      destruct b as [|w b]; simpl; auto.
      copy_destruct ((a == w)%bool); rewrite ew; simpl.
         assert (phi' i a == phi' i w) as q1.
            apply (pres_eq' i); auto.
         rewrite q1; simpl. dseq_u; simpl. rewrite refl; simpl; auto.
         apply IHa.
         
         assert ((phi' i a == phi' i w)%bool = false) as q2.
            bool_p; intros h; apply ew; dseq_f.
            rewrite <- (inv i a), <- (inv i w); apply (pres_eq i); auto.
         rewrite q2; simpl; auto.
   Qed.

   Lemma isoPres : forall (x x' : DecSetoid), DsIso x x' ->
      SmgIso (prefixSemigroup x) (prefixSemigroup x').
   Proof. intros x x' i; split with (Seq.isoPres _ _ i).
      split; simpl; intros a b; simpl.
      apply (prefix_phi i).
      apply (prefix_phi' i).
   Defined.

   Lemma idPres : forall (x x' : DecSetoid), IdDsIso x x' ->
      IdSmgIso (prefixSemigroup x) (prefixSemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *.
      
      clear -ip1; destruct ip1; split; intros l; induction l; auto; simpl;
      rewrite IHl, (H a); auto.

      clear -ip1'; destruct ip1'; split; intros l; induction l; auto; simpl;
      rewrite IHl, (H a); auto.
   Defined.

End IsoPres.
