Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.Semigroups.Prefix.
Require Import Metarouting.Constructions.Semigroups.Postfix.
Require Import Metarouting.IsoPres.DecSetoids.Seq.
Require Import Metarouting.IsoPres.Semigroups.Prefix.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres : forall (x x' : DecSetoid), DsIso x x' ->
      SmgIso (postfixSemigroup x) (postfixSemigroup x').
   Proof. intros x x' i; split with (DecSetoids.Seq.isoPres _ _ i).
      split; simpl; intros a b; simpl.
      unfold postfix.
      rewrite map_rev. apply (rev_pres_eq x').
      repeat rewrite <- (map_rev).
      apply (prefix_phi i).
      unfold postfix.
      rewrite map_rev. apply (rev_pres_eq x).
      repeat rewrite <- (map_rev).
      apply (prefix_phi' i).
   Defined.

   Lemma idPres : forall (x x' : DecSetoid), IdDsIso x x' ->
      IdSmgIso (postfixSemigroup x) (postfixSemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *.
      
      clear -ip1; destruct ip1; split; intros l; induction l; auto; simpl;
      rewrite IHl, (H a); auto.

      clear -ip1'; destruct ip1'; split; intros l; induction l; auto; simpl;
      rewrite IHl, (H a); auto.
   Defined.

End IsoPres.
