Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.Semigroups.Lex.
Require Import Metarouting.IsoPres.DecSetoids.Product.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' y y' : Semigroup), DsIso x x' -> DsIso y y' ->
      forall comm idem hasId comm' idem' hasId', 
         DsIso (lexSemigroup x y comm idem hasId) (lexSemigroup x' y' comm' idem' hasId').
   Proof. intros x x' y y' i i' comm idem hasId comm' idem' hasId'; 
      destruct x; destruct x'; destruct y; destruct y'; simpl.
      apply Product.isoPres. apply i. apply i'.
   Defined.

   Lemma isoPres : forall x x' y y', SmgIso x x' -> SmgIso y y' -> 
      forall comm idem hasId comm' idem' hasId',
         SmgIso (lexSemigroup x y comm idem hasId) (lexSemigroup x' y' comm' idem' hasId').
   Proof. intros x x' y y' i i' comm idem hasId comm' idem' hasId'. 
      set (X := x); set (X' := x'); set (ISO := i);
      set (Y := y); set (Y' := y'); set (ISO' := i');
      apply (Build_SmgIso) with (isoPres_helper x x' y y' i i' comm idem hasId comm' idem' hasId').
      split; simpl; intros [a1 a2] [b1 b2]; unfold isoPres_helper; simpl;
      destruct x; destruct x'; destruct i; simpl;
      destruct y; destruct y'; destruct i'; simpl;
      unfold lexOp; simpl; dseq_u; simpl; toProp; split; dseq_f.
      
      apply (pres_op isSmgIso).
      
      assert (lexComp X' (phi dsIso a1) (phi dsIso b1) = lexComp X a1 b1).
         copy_destruct (lexComp X a1 b1); rewrite ew;
         rewrite ?lexComp_equiv, ?lexComp_less, ?lexComp_more, ?lexComp_none in *; auto;
         destruct ew; split; dseq_f; simpl in *;
         try (rewrite <- (pres_op isSmgIso a1 b1), H; auto; fail);
         try (rewrite <- (pres_op isSmgIso b1 a1), H0; auto; fail);
         try (rewrite <- (pres_op isSmgIso b1 a1); intros h; elim H0; dseq_f;
         assert (h' := pres_eq' dsIso h); do 2 rewrite (inv' dsIso) in h'; apply h'; fail);
         try (rewrite <- (pres_op isSmgIso a1 b1); intros h; elim H; dseq_f;
         assert (h' := pres_eq' dsIso h); do 2 rewrite (inv' dsIso) in h'; apply h'; fail).
      unfold X' in H; simpl in H; rewrite H.
      fold X; destruct (lexComp X a1 b1); auto.
         apply (pres_op isSmgIso0).
         destruct hasId as [id p]; destruct hasId' as [id' p']; simpl in *.
         destruct (p' (phi dsIso0 id)); rewrite <- H0.
         destruct (p (phi' dsIso0 id')).
         apply (@trans setoid2 _ (phi dsIso0 (op1 (phi' dsIso0 id') id))); auto; dseq_f.
            rewrite (pres_op isSmgIso0), (inv dsIso0); auto.
            rewrite H3, (inv dsIso0); auto.

      apply (pres_op' isSmgIso a1 b1).

      assert (lexComp X (phi' dsIso a1) (phi' dsIso b1) = lexComp X' a1 b1).
         copy_destruct (lexComp X' a1 b1); rewrite ew;
         rewrite ?lexComp_equiv, ?lexComp_less, ?lexComp_more, ?lexComp_none in *; auto;
         destruct ew; split; dseq_f; simpl in *;
         try (rewrite <- (pres_op' isSmgIso a1 b1), H; auto; fail);
         try (rewrite <- (pres_op' isSmgIso b1 a1), H0; auto; fail);
         try (rewrite <- (pres_op' isSmgIso b1 a1); intros h; elim H0; dseq_f;
         assert (h' := pres_eq dsIso h); do 2 rewrite (inv dsIso) in h'; apply h'; fail);
         try (rewrite <- (pres_op' isSmgIso a1 b1); intros h; elim H; dseq_f;
         assert (h' := pres_eq dsIso h); do 2 rewrite (inv dsIso) in h'; apply h'; fail).
      unfold X in H; simpl in H; rewrite H.
      fold X'; destruct (lexComp X' a1 b1); auto.
         apply (pres_op' isSmgIso0).
         destruct hasId as [id p]; destruct hasId' as [id' p']; simpl in *.
         destruct (p (phi' dsIso0 id'));
         destruct (p' (phi dsIso0 id)). rewrite <- H0.
         apply (@trans setoid1 _ (phi' dsIso0 (op2 (phi dsIso0 id) id'))); auto; dseq_f.
            rewrite (pres_op' isSmgIso0), (inv' dsIso0); auto.
            rewrite H3, (inv' dsIso0); auto.
   Defined.

   Lemma idPres : forall x x' y y', IdSmgIso x x' -> IdSmgIso y y' -> 
      forall comm idem hasId comm' idem' hasId',
         IdSmgIso (lexSemigroup x y comm idem hasId) (lexSemigroup x' y' comm' idem' hasId').
   Proof. intros x x' y y' i i' comm idem hasId comm' idem' hasId';
      split with (isoPres x x' y y' i i' comm idem hasId comm' idem' hasId'); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct i' as [[[phi2 phi2']] [ip2 ip2']]; simpl in *;
      destruct x; destruct x'; destruct y; destruct y'; simpl in *.
      
      clear -ip1 ip2; destruct ip1; destruct ip2; split; intros [x1 x2]; rewrite (H x1), (H0 x2); auto.

      clear -ip1' ip2'; destruct ip1'; destruct ip2'; split; intros [x1 x2]; rewrite (H x1), (H0 x2); auto.
   Defined.

End IsoPres.
