Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.Constructions.Semigroups.FSetOp.
Require Import Metarouting.IsoPres.DecSetoids.FSets.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.
Require Import Coq.Bool.Bool.

Section IsoPres.


   Lemma isoPres_helper : forall x x', SmgIso x x' -> DsIso (fsetOpSemigroup x) (fsetOpSemigroup x').
   Proof. intros x x' i; destruct x; destruct x'; simpl.
      apply FSets.isoPres. apply i.
   Defined.

   Lemma phi_fset_op : forall (A B : Semigroup) (i : SmgIso A B) x y, @dseq (fsetDecSetoid B) 
                                                     (map (phi i) (fset_op A x y))
                                                     (fset_op B (map (phi i) x) (map (phi i) y)).
         clear.
         intros. induction x; simpl; auto.
         unfold fset_op in *; simpl in *.
         repeat rewrite map_app in *.
         repeat rewrite map_map in *.
         toSet_u.
         repeat rewrite mem_app.
         rewrite IHx.
         match goal with
            | |- (_ || ?X) = _ => destruct X; do 2 rewrite ?orb_false_r, ?orb_true_r; auto
         end.
         clear; induction y; simpl; auto.
         rewrite IHy.
         rewrite (pres_op i a a1).
         auto.
   Qed.

   Lemma phi_fset_op' : forall (A B : Semigroup) (i : SmgIso A B) x y, @dseq (fsetDecSetoid A) 
                                                     (map (phi' i) (fset_op B x y))
                                                     (fset_op A (map (phi' i) x) (map (phi' i) y)).
         clear.
         intros. induction x; simpl; auto.
         unfold fset_op in *; simpl in *.
         repeat rewrite map_app in *.
         repeat rewrite map_map in *.
         toSet_u.
         repeat rewrite mem_app.
         rewrite IHx.
         match goal with
            | |- (_ || ?X) = _ => destruct X; do 2 rewrite ?orb_false_r, ?orb_true_r; auto
         end.
         clear; induction y; simpl; auto.
         rewrite IHy.
         rewrite (pres_op' i a a1).
         auto.
   Qed.  

   Lemma isoPres : forall x x', SmgIso x x' -> SmgIso (fsetOpSemigroup x) (fsetOpSemigroup x').
   Proof. intros x x' i.
      set (iso := i);
      apply (Build_SmgIso) with (isoPres_helper x x' i).
      split; simpl; intros a b; unfold isoPres_helper; simpl;
      destruct x; destruct x'; destruct i; simpl.
      apply (phi_fset_op _ _ iso).
      apply (phi_fset_op' _ _ iso).
   Defined.

   Lemma idPres : forall x x', IdSmgIso x x' -> IdSmgIso (fsetOpSemigroup x) (fsetOpSemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; apply IsId_map; auto.
   Defined.

End IsoPres.