Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Constructions.Transforms.Union.
Require Import Metarouting.Constructions.SemigroupTransforms.Union.
Require Import Metarouting.IsoPres.DecSetoids.Union.
Require Import Metarouting.IsoPres.Transforms.Union.
Require Import Metarouting.IsoPres.SemigroupTransforms.Glue.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres : forall (a b c d : SemigroupTransform) (ab : IdSmgIso a b) (cd : IdSmgIso c d),
      IdSTfIso a c -> IdSTfIso b d ->
         STfIso (unionSemigroupTransform a b ab) (unionSemigroupTransform c d cd).
   Proof. intros a b c d ab cd ac bd.
      set (A := a); set (B := b); set (C := c); set (D := d);
      unfold unionSemigroupTransform.
      destruct a as [[crA chooseA equalA reflA symA transA] opA assocA op_pres_eqA fnA appA app_pres_eqA];
      destruct b as [[crB chooseB equalB reflB symB transB] opB assocB op_pres_eqB fnB appB app_pres_eqB];
      destruct c as [[crC chooseC equalC reflC symC transC] opC assocC op_pres_eqC fnC appC app_pres_eqC];
      destruct d as [[crD chooseD equalD reflD symD transD] opD assocD op_pres_eqD fnD appD app_pres_eqD];
      simpl in *.
      
      apply Glue.isoPres.

      split with ac (DecSetoids.Union.isoPres fnA fnC fnB fnD (fnIso ac) (fnIso bd)); simpl in *.
      split; simpl; unfold union_app; simpl.



      intros [f|f] x; simpl; [apply (Transform.pres_app ac)|].
         assert (p := pres_eq ac (pres_eq' ab (pres_eq' bd (Transform.pres_app bd f (phi ab x)))));
         rewrite (inv' bd) in p;  simpl in p.
         destruct ab as [[[phi_ab phi_ab']] [ab_id ab_id']]; simpl in *.
            destruct ab_id as [phi_ab phi_ab_eq]; simpl in *.
            assert (phi_ab_eq' := IsId_ext_eq _ ab_id').
            rewrite phi_ab_eq, phi_ab_eq' in *; unfold id in *; simpl.
         destruct cd as [[[phi_cd phi_cd']] [cd_id cd_id']]; simpl in *.
            destruct cd_id as [phi_cd phi_cd_eq]; simpl in *.
            assert (phi_cd_eq' := IsId_ext_eq _ cd_id').
            rewrite phi_cd_eq, phi_cd_eq'; unfold id; simpl.
         destruct ac as [[[phi_ac phi_ac'] [fphi_ac fphi_ac']] [ac_id ac_id'][fac_id fac_id']]; simpl in *.
            destruct ac_id as [phi_ac phi_ac_eq]; simpl in *.
            assert (phi_ac_eq' := IsId_ext_eq _ ac_id').
            do 2 rewrite phi_ac_eq in *; unfold id; simpl.
         destruct bd as [[[phi_bd phi_bd'] [fphi_bd fphi_bd']] [bd_id bd_id'][fbd_id fbd_id']]; simpl in *.
            assert (phi_bd_eq := IsId_ext_eq _ bd_id).
            assert (phi_bd_eq' := IsId_ext_eq _ bd_id').
            rewrite phi_bd_eq, phi_bd_eq' in p; unfold id in *; simpl.
            rewrite phi_ab_eq' in p.
         apply p.

      intros [f|f] x; simpl; [apply (Transform.pres_app' ac)|].
         assert (p := pres_eq' ac (pres_eq' cd (pres_app bd (phi' (fnIso bd) f) (phi ab (phi' ac x))))); simpl in p.
         
         assert (forall w1 w2 : D, w1 == w2 -> phi' ac (phi' cd w1) == phi' ac (phi' cd w2)) as h.
            intros w1 w2 h1; apply (pres_eq' ac); apply (pres_eq' cd); apply h1.
         
         destruct ab as [[[phi_ab phi_ab']] [ab_id ab_id']]; simpl in *.
            destruct ab_id as [phi_ab phi_ab_eq]; simpl in *.
            assert (phi_ab_eq' := IsId_ext_eq _ ab_id').
            rewrite phi_ab_eq, phi_ab_eq' in *; unfold id in *; simpl.
         destruct cd as [[[phi_cd phi_cd']] [cd_id cd_id']]; simpl in *.
            destruct cd_id as [phi_cd phi_cd_eq]; simpl in *.
            assert (phi_cd_eq' := IsId_ext_eq _ cd_id').
            rewrite phi_cd_eq, phi_cd_eq'; unfold id; simpl.
         destruct ac as [[[phi_ac phi_ac'] [fphi_ac fphi_ac']] [ac_id ac_id'][fac_id fac_id']]; simpl in *.
            destruct ac_id as [phi_ac phi_ac_eq]; simpl in *.
            assert (phi_ac_eq' := IsId_ext_eq _ ac_id').
            do 2 rewrite phi_ac_eq' in *; unfold id; simpl.
         destruct bd as [[[phi_bd phi_bd'] [fphi_bd fphi_bd']] [bd_id bd_id'][fbd_id fbd_id']]; simpl in *.
            assert (phi_bd_eq := IsId_ext_eq _ bd_id).
            assert (phi_bd_eq' := IsId_ext_eq _ bd_id').
            repeat rewrite phi_bd_eq in p.
            repeat rewrite phi_cd_eq' in p.
            rewrite phi_ac_eq' in p.
            unfold id in p; simpl in p.
            rewrite p.
            match goal with
               |- @dseq _ ?X ?Y => assert (h1 := h X Y)
            end.
            repeat rewrite phi_ac_eq' in h1.
            repeat rewrite phi_cd_eq' in h1.
            unfold id in h1; simpl in h1.
            apply h1.
            assert (q := app_pres_eqD x x f (fphi_bd (fphi_bd' f)) (refl D x)).
            apply q.
            rewrite (inv isDsIso4). auto.
   Defined.      

   Lemma idPres : forall (a b c d : SemigroupTransform) (ab : IdSmgIso a b) (cd : IdSmgIso c d),
      IdSTfIso a c -> IdSTfIso b d ->
         IdSTfIso (unionSemigroupTransform a b ab) (unionSemigroupTransform c d cd).
   Proof. intros A B C D ab cd ac bd.
      split with (isoPres A B C D ab cd ac bd); split;
      destruct A as [[crA chooseA equalA reflA symA transA] fnA appA app_pres_eqA];
      destruct B as [[crB chooseB equalB reflB symB transB] fnB appB app_pres_eqB];
      destruct C as [[crC chooseC equalC reflC symC transC] fnC appC app_pres_eqC];
      destruct D as [[crD chooseD equalD reflD symD transD] fnD appD app_pres_eqD];
      simpl in *; auto.

      apply ac.

      apply ac.

      destruct ac as [[ac_dsIso [ac_fnphi ac_fnphi']] [] [ac_id ac_id']]; simpl in *;
      destruct bd as [[bd_dsIso [bd_fnphi bd_fnphi']] [] [bd_id bd_id']]; simpl in *.
      clear - ac_id ac_id' bd_id bd_id'.
      destruct ac_id. destruct bd_id. split. intros [x|x]; simpl; unfold id; simpl.
         rewrite (H x); auto.
         rewrite (H0 x); auto.

      destruct ac as [[ac_dsIso [ac_fnphi ac_fnphi']] [] [ac_id ac_id']]; simpl in *;
      destruct bd as [[bd_dsIso [bd_fnphi bd_fnphi']] [] [bd_id bd_id']]; simpl in *.
      clear - ac_id ac_id' bd_id bd_id'.
      destruct ac_id'. destruct bd_id'. split. intros [x|x]; simpl; unfold id; simpl.
         rewrite (H x); auto.
         rewrite (H0 x); auto.
   Defined.

End IsoPres.