Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Constructions.DecSetoids.Unit.
Require Import Metarouting.Constructions.SemigroupTransforms.Right.
Require Import Metarouting.IsoPres.Transforms.Id.
Require Import Metarouting.IsoPres.SemigroupTransforms.Glue.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres : forall (x x' : Semigroup), SmgIso x x' ->
      STfIso (rightSemigroupTransform x) (rightSemigroupTransform x').
   Proof. intros x x' i;
      set (X := x); set (X' := x').
      
      apply Glue.isoPres.

      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *.
      
      split with i (DsIso_refl unitDecSetoid).
      apply (isTfIso (IsoPres.Transforms.Id.isoPres _ _ i)).
   Defined.

   Lemma idPres : forall (x x' : Semigroup), IdSmgIso x x' ->
      IdSTfIso (rightSemigroupTransform x) (rightSemigroupTransform x').
   Proof.  intros x x' i.
      split with (isoPres x x' i); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *; auto.
      split; intros x; auto.
      split; intros x; auto.
   Defined.

End IsoPres.

