Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.SemigroupTransform.
Require Import Metarouting.Signatures.SemigroupTransformGlue.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : Semigroup) (y y' : Transform) e e', SmgIso x x' -> TfIso y y' ->
      DsIso (glueSTf_DsEq x y e) (glueSTf_DsEq x' y' e').
   Proof. intros x x' y y' e e' i i'.
      destruct x; destruct x'; destruct y; destruct y'; simpl in *;
      destruct e; destruct e'.
      apply i.
      (* destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *;
      destruct y; destruct y'; destruct setoid; destruct setoid0; simpl in *.
      unfold glueSTf_DsEq; simpl.
      unfold DsEq in *; simpl in *.
      destruct e; destruct e'.
      apply i. *)
   Defined.
   
   Definition GlueSTfIsoEq (x x' : Semigroup) (y y' : Transform) (e : DsEq x y) (e' : DsEq x' y') 
      (i : DsIso x x') (i' : DsIso (Transform.fn y) (Transform.fn y')) : Type.
      intros.
      set (Y := y); set (Y' := y').
      destruct x; destruct x'; (* destruct setoid; destruct setoid0; simpl in *; *)
      destruct y; destruct y'; (* destruct setoid; destruct setoid0; *) simpl in *.
      (* unfold DsEq in *; simpl in *. *)
      destruct e; destruct e'.
      apply (IsTfIso Y Y' i i').
   Defined.
   
   Record GlueSTfIso (x x' : Semigroup) (y y' : Transform) (e : DsEq x y) (e' : DsEq x' y')  : Type := {
      gstSmgIso  : SmgIso x x';
      gstFnDsIso : DsIso (Transform.fn y) (Transform.fn y');
      gstSTfIso  : GlueSTfIsoEq x x' y y' e e' gstSmgIso gstFnDsIso (* a compatible isomorphism*)
   }. 

   Lemma isoPres : forall (x x' : Semigroup) (y y' : Transform) e e', GlueSTfIso x x' y y' e e' ->
      STfIso (glueSTf_DsEq x y e) (glueSTf_DsEq x' y' e').
   Proof. intros x x' y y' e e' gbs.
      destruct x; destruct x'; (* destruct setoid; destruct setoid0; simpl in *; *)
      destruct y; destruct y'; (* destruct setoid; destruct setoid0; *) simpl in *.
      unfold glueSTf_DsEq; simpl.
      (* unfold DsEq in *; simpl in *. *)
      destruct e; destruct e'.
      
      destruct gbs as [i1 i2 i3].
      
      split with (Semigroup.dsIso i1) i2; split; simpl in *.
      apply (Semigroup.pres_op  i1).
      apply (Semigroup.pres_op' i1).
      apply (Transform.pres_app  i3).
      apply (Transform.pres_app' i3).
   Defined. 

End IsoPres.
