Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Constructions.Preorders.RightNaturalOrder.
Require Import Metarouting.Constructions.Preorders.LeftNaturalOrder.
Require Import Metarouting.IsoPres.Preorders.LeftNaturalOrder.
Require Import Metarouting.IsoPres.Preorders.Dual.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres : forall (x x' : Semigroup), SmgIso x x' ->
      forall idem idem',
         ProIso (rightNaturalOrder x idem) (rightNaturalOrder x' idem').
   Proof. intros x x' i idem idem'.
      split with (Semigroup.dsIso i); split; simpl;
      intros a b p; unfold rle in *; simpl in *; dseq_f.
         rewrite <- (pres_op i), p; auto.
         rewrite <- (pres_op' i), p; auto.
   Defined.

   Lemma idPres : forall (x x' : Semigroup), IdSmgIso x x' ->
      forall idem idem',
         IdProIso (rightNaturalOrder x idem) (rightNaturalOrder x' idem').
   Proof. intros x x' i idem idem'; split with (isoPres x x' i idem idem'); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; auto.
   Defined.

End IsoPres.
