Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Constructions.Preorders.LeftNaturalOrder.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : Semigroup), DsIso x x' ->
      forall idem idem', DsIso (leftNaturalOrder x idem) (leftNaturalOrder x' idem').
   Proof. intros x x' i idem idem'. apply i. Defined.

   Lemma isoPres : forall (x x' : Semigroup), SmgIso x x' ->
      forall idem idem', ProIso (leftNaturalOrder x idem) (leftNaturalOrder x' idem').
   Proof. intros x x' i idem idem';
      set (X := x); set (X' := x'); set (ISO := i);
      apply (Build_ProIso) with (isoPres_helper x x' i idem idem').
      split; simpl; intros a b; unfold isoPres_helper; simpl; unfold le; dseq_f; intros p.
      rewrite <- (pres_op i), p; auto.
      rewrite <- (pres_op' i), p; auto.
   Defined.

   Lemma idPres : forall (x x' : Semigroup), IdSmgIso x x' ->
      forall idem idem', IdProIso (leftNaturalOrder x idem) (leftNaturalOrder x' idem').
   Proof. intros x x' i idem idem'; split with (isoPres x x' i idem idem'); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; auto.
   Defined.

End IsoPres.
