Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupProperties.
Require Import Metarouting.Signatures.Preorder.
Require Import Metarouting.Constructions.Preorders.AnnTop.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : Semigroup), DsIso x x' ->
      forall hasAnn hasAnn', DsIso (annTopPreorder x hasAnn) (annTopPreorder x' hasAnn').
   Proof. intros x x' i hasAnn hasAnn'. apply i. Defined.

   Lemma isoPres : forall (x x' : Semigroup), SmgIso x x' ->
      forall hasAnn hasAnn', ProIso (annTopPreorder x hasAnn) (annTopPreorder x' hasAnn').
   Proof. intros x x' i hasAnn hasAnn';
      set (X := x); set (X' := x'); set (ISO := i);
      apply (Build_ProIso) with (isoPres_helper x x' i hasAnn hasAnn').
      split; simpl; intros a b; unfold isoPres_helper; simpl; unfold ann_le; dseq_f; intros p.
      toProp; destruct p as [p|p]; dseq_f.
         rewrite p. auto.
         rewrite p. apply or_intror. unfold ann; simpl.
         rewrite (Iso_PresAnn' i hasAnn hasAnn'). auto.
      toProp; destruct p as [p|p]; dseq_f.
         rewrite p. auto.
         rewrite p. apply or_intror. unfold ann; simpl.
         rewrite (Iso_PresAnn i hasAnn hasAnn'). auto.
   Defined.

   Lemma idPres : forall (x x' : Semigroup), IdSmgIso x x' ->
      forall hasAnn hasAnn', IdProIso (annTopPreorder x hasAnn) (annTopPreorder x' hasAnn').
   Proof. intros x x' i hasAnn hasAnn'; split with (isoPres x x' i hasAnn hasAnn'); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; simpl in *; auto.
   Defined.

End IsoPres.
