Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Constructions.Preorders.AnnTop.
Require Import Metarouting.Constructions.Semigroups.SimpleSeq.
Require Import Metarouting.Constructions.OrderSemigroups.SimpleSeq.
Require Import Metarouting.IsoPres.DecSetoids.SimpleSeq.
Require Import Metarouting.IsoPres.Semigroups.SimpleSeq.
Require Import Metarouting.IsoPres.Preorders.AnnTop.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : DecSetoid), DsIso x x' ->
      DsIso (simpleSeqOrderSemigroup x) (simpleSeqOrderSemigroup x').
   Proof. intros x x' i. apply (SimpleSeq.isoPres _ _ i). Defined.

   Lemma isoPres : forall (x x' : DecSetoid), DsIso x x' ->
      OSmgIso (simpleSeqOrderSemigroup x) (simpleSeqOrderSemigroup x').
   Proof. intros x x' i. split with (DecSetoids.SimpleSeq.isoPres _ _ i); split; simpl.
      
      apply (Semigroup.pres_op (Semigroups.SimpleSeq.isoPres _ _ i)).
      apply (Semigroup.pres_op' (Semigroups.SimpleSeq.isoPres _ _ i)).
      apply (Preorder.pres_le (Preorders.AnnTop.isoPres _ _ (Semigroups.SimpleSeq.isoPres _ _ i) (hasAnnihilator x) (hasAnnihilator x'))).
      apply (Preorder.pres_le' (Preorders.AnnTop.isoPres _ _ (Semigroups.SimpleSeq.isoPres _ _ i) (hasAnnihilator x) (hasAnnihilator x'))).
   Defined.

   Lemma idPres : forall (x x' : DecSetoid), IdDsIso x x' ->
      IdOSmgIso (simpleSeqOrderSemigroup x) (simpleSeqOrderSemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *.
      clear -ip1; destruct ip1; split; intros l; induction l; auto; simpl;
      rewrite IHl, (H a); auto.
      clear -ip1'; destruct ip1'; split; intros l; induction l; auto; simpl;
      rewrite IHl, (H a); auto.
   Defined.

End IsoPres.
