Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Constructions.OrderSemigroups.Dual.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : OrderSemigroup), OSmgIso x x' ->
      DsIso (dualOrderSemigroup x) (dualOrderSemigroup x').
   Proof. intros x x' i. destruct x; destruct x'; 
      destruct setoid; destruct setoid0; simpl in *. apply i.
   Defined.

   Lemma isoPres : forall (x x' : OrderSemigroup), OSmgIso x x' ->
      OSmgIso (dualOrderSemigroup x) (dualOrderSemigroup x').
   Proof. intros x x' i. split with (isoPres_helper x x' i).
      destruct x; destruct x'; 
      destruct setoid; destruct setoid0; simpl in *. destruct i; split; simpl in *.
      
      apply (pres_op isOSmgIso).
      apply (pres_op' isOSmgIso).
      intros x y; apply (pres_le isOSmgIso).
      intros x y; apply (pres_le' isOSmgIso).
   Defined.

   Lemma idPres : forall (x x' : OrderSemigroup), IdOSmgIso x x' ->
      IdOSmgIso (dualOrderSemigroup x) (dualOrderSemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *; auto.
   Defined.

End IsoPres.
