Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Signatures.OrderSemigroup.
Require Import Metarouting.Constructions.Preorders.LeftNaturalOrder.
Require Import Metarouting.Constructions.OrderSemigroups.BSLeftNaturalOrder.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : Bisemigroup) idem idem', BSmgIso x x' ->
      DsIso (bsLeftNaturalOrder x idem) (bsLeftNaturalOrder x' idem').
   Proof. intros x x' idem idem' i. destruct x; destruct x'; 
      destruct setoid; destruct setoid0; simpl in *. apply i.
   Defined.

   Lemma isoPres : forall (x x' : Bisemigroup) idem idem', BSmgIso x x' ->
      OSmgIso (bsLeftNaturalOrder x idem) (bsLeftNaturalOrder x' idem').
   Proof. intros x x' idem idem' i. split with (isoPres_helper x x' idem idem' i).
      destruct x; destruct x'; 
      destruct setoid; destruct setoid0; simpl in *. destruct i; split; simpl in *.
      
      apply (Bisemigroup.pres_times isBSmgIso).
      apply (Bisemigroup.pres_times' isBSmgIso).
      intros x y; unfold le; dseq_f; intros p. 
      assert (h := Bisemigroup.pres_plus isBSmgIso x y); simpl in h. simpl in *.
      rewrite <- h, p. auto.
      intros x y; unfold le; dseq_f; intros p. 
      assert (h := Bisemigroup.pres_plus' isBSmgIso x y); simpl in h. simpl in *.
      rewrite <- h, p. auto.
   Defined.

   Lemma idPres : forall (x x' : Bisemigroup) idem idem', IdBSmgIso x x' ->
      IdOSmgIso (bsLeftNaturalOrder x idem) (bsLeftNaturalOrder x' idem').
   Proof. intros x x' idem idem' i; split with (isoPres x x' idem idem' i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *; auto.
   Defined.

End IsoPres.
