Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Constructions.DecSetoids.SimpleSeq.
Require Import Metarouting.Constructions.DecSetoids.FSets.
Require Import Metarouting.IsoPres.DecSetoids.Seq.
Require Import Metarouting.IsoPres.DecSetoids.FSets.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma simple_phi : forall x y (i : DsIso x y) (a : list x), simple x a = simple y (map (phi i) a).
   Proof. intros x y i a.
      induction a. trivial.
      simpl.
      assert (mem a a0 = mem (phi i a) (map (phi i) a0)) as q; [|rewrite <- q, <- IHa; auto].
      rewrite (mem_phi' i). rewrite map_map.
      rewrite bool_eq; split; intros h.
      apply mem_map_intro.
         intros w1 w2 w3; repeat rewrite (inv' i); auto.
         exists a; split; auto. rewrite (inv' i); auto.
      destruct (mem_map_elim _ _ _ h) as [c [p1 p2]].
      rewrite (inv' i) in p1.
      rewrite (mem_pres_eq _ p1); auto.
   Qed.

   Lemma simple_phi' : forall x y (i : DsIso x y) (a : list y), simple y a = simple x (map (phi' i) a).
   Proof. intros x y i a.
      induction a. trivial.
      simpl.
      assert (mem a a0 = mem (phi' i a) (map (phi' i) a0)) as q; [|rewrite <- q, <- IHa; auto].
      rewrite (mem_phi i). rewrite map_map.
      rewrite bool_eq; split; intros h.
      apply mem_map_intro.
         intros w1 w2 w3; repeat rewrite (inv i); auto.
         exists a; split; auto. rewrite (inv i); auto.
      destruct (mem_map_elim _ _ _ h) as [c [p1 p2]].
      rewrite (inv i) in p1.
      rewrite (mem_pres_eq _ p1); auto.
   Qed.

   Lemma isoPres : forall x y, DsIso x y -> DsIso (simpleSeqDecSetoid x) (simpleSeqDecSetoid y).
   Proof. intros x y i.
      apply (@Build_DsIso (simpleSeqDecSetoid x) (simpleSeqDecSetoid y)
         (map (phi i))
         (map (phi' i))).
      split.

      intros a b; dseq_u; simpl. unfold sseq_eq; simpl.
         repeat rewrite <- simple_phi.
         toProp; dseq_f; intros [p|[p q]]. auto.
            apply or_intror; split; auto.
            apply (pres_eq (Seq.isoPres _ _ i) q).

      intros a b; dseq_u; simpl. unfold sseq_eq; simpl.
         repeat rewrite <- simple_phi'.
         toProp; dseq_f; intros [p|[p q]]. auto.
            apply or_intror; split; auto.
            apply (pres_eq' (Seq.isoPres _ _ i) q).
      
      intros a; dseq_u; simpl. unfold sseq_eq; simpl.
      repeat rewrite <- simple_phi.
      repeat rewrite <- simple_phi'.
      destruct (simple y a); simpl; auto.
      apply (inv (Seq.isoPres _ _ i)).

      intros a; dseq_u; simpl. unfold sseq_eq; simpl.
      repeat rewrite <- simple_phi'.
      repeat rewrite <- simple_phi.
      destruct (simple x a); simpl; auto.
      apply (inv' (Seq.isoPres _ _ i)).
   Defined.
   
   Lemma idPres : forall x y, IdDsIso x y -> IdDsIso (simpleSeqDecSetoid x) (simpleSeqDecSetoid y).
   Proof. intros x y i. split with (isoPres x y i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *.
      
      clear - ip1; destruct ip1; split; intros l; 
      induction l; auto; simpl; rewrite IHl; rewrite (H a); auto.
   
      clear - ip1'; destruct ip1'; split; intros l; 
      induction l; auto; simpl; rewrite IHl; rewrite (H a); auto.
   Defined.

End IsoPres.