Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Constructions.DecSetoids.Seq.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres : forall x y, DsIso x y -> DsIso (seqDecSetoid x) (seqDecSetoid y).
   Proof. intros x y i.
      apply (@Build_DsIso (seqDecSetoid x) (seqDecSetoid y)
         (map (phi i))
         (map (phi' i))).
      split.
      dseq_u; simpl in *; intros a; induction a.
         intros [|w b]; auto.
         intros [|w b]; simpl; auto.
         copy_destruct ((a == w)%bool) as h; rewrite h; simpl.
         intros p; rewrite (pres_eq i); auto; simpl; auto.
         intros p; discriminate.
      dseq_u; simpl in *; intros a; induction a.
         intros [|w b]; auto.
         intros [|w b]; simpl; auto.
         copy_destruct ((a == w)%bool) as h; rewrite h; simpl.
         intros p; rewrite (pres_eq' i); auto; simpl; auto.
         intros p; discriminate.
      dseq_u; simpl in *; intros a; induction a; auto.
         simpl; rewrite (inv i); simpl; auto.
      dseq_u; simpl in *; intros a; induction a; auto.
         simpl; rewrite (inv' i); simpl; auto.
   Defined.
   
   Lemma idPres : forall x y, IdDsIso x y -> IdDsIso (seqDecSetoid x) (seqDecSetoid y).
   Proof. intros x y i. split with (isoPres x y i); split;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *.
      
      clear - ip1; destruct ip1; split; intros l; 
      induction l; auto; simpl; rewrite IHl; rewrite (H a); auto.
   
      clear - ip1'; destruct ip1'; split; intros l; 
      induction l; auto; simpl; rewrite IHl; rewrite (H a); auto.
   Defined.

End IsoPres.