Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Constructions.DecSetoids.Product.
Require Import Metarouting.Signatures.IdArrow.

Section IsoPres.

   Lemma isoPres : forall x y x' y', DsIso x y -> DsIso x' y' -> DsIso (prodDecSetoid x x') (prodDecSetoid y y').
   Proof. intros x y x' y' i i'.
      apply (@Build_DsIso (prodDecSetoid x x') (prodDecSetoid y y')
         (fun a => match a with 
            | (a1, a2) => (phi i a1, phi i' a2) 
          end)
         (fun a => match a with 
            | (a1, a2) => (phi' i a1, phi' i' a2) 
          end)).
      split.
      intros [a1 a2] [b1 b2]; dseq_u; simpl; toProp; intros [e1 e2]; split; auto.
         apply (pres_eq i); auto.
         apply (pres_eq i'); auto.
      intros [a1 a2] [b1 b2]; dseq_u; simpl; toProp; intros [e1 e2]; split; auto.
         apply (pres_eq' i); auto.
         apply (pres_eq' i'); auto.
      intros [a1 a2]; dseq_u; simpl; toProp; split; auto.
         apply (inv i); auto.
         apply (inv i'); auto.
      intros [a1 a2]; dseq_u; simpl; toProp; split; auto.
         apply (inv' i); auto.
         apply (inv' i'); auto.
   Defined.
   
   Lemma idPres : forall x y x' y', IdDsIso x y -> IdDsIso x' y' -> IdDsIso (prodDecSetoid x x') (prodDecSetoid y y').
   Proof. intros x y x' y' i i'.
      split with (isoPres x y x' y' i i'); split; simpl;
      destruct i as [[phi1 phi1'] [ip1 ip1']]; simpl in *;
      destruct i' as [[phi2 phi2'] [ip2 ip2']]; simpl in *.
      
      clear - ip1 ip2; destruct ip1; destruct ip2; split; 
      intros [x1 x2]; rewrite (H x1), (H0 x2); auto.

      clear - ip1' ip2'; destruct ip1'; destruct ip2'; split; 
      intros [x1 x2]; rewrite (H x1), (H0 x2); auto.
   Defined.

End IsoPres.