Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Constructions.Bisemigroups.Swap.
Require Import Metarouting.IsoPres.Bisemigroups.Glue.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres : forall (x x' : Bisemigroup), BSmgIso x x' ->
      BSmgIso (swapBisemigroup x) (swapBisemigroup x').
   Proof. intros x x' i;
      set (X := x); set (X' := x').
      
      apply Glue.isoPres.

      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *.
      
      split with (timesSmgBSmgIso i). simpl.
      apply (isSmgIso (plusSmgBSmgIso i)).
   Defined.

   Lemma idPres : forall (x x' : Bisemigroup), IdBSmgIso x x' ->
      IdBSmgIso (swapBisemigroup x) (swapBisemigroup x').
   Proof.  intros x x' i.
      split with (isoPres x x' i); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *; auto.
   Defined.

End IsoPres.

