Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Constructions.Semigroups.Product.
Require Import Metarouting.Constructions.Bisemigroups.Product.
Require Import Metarouting.IsoPres.Semigroups.Product.
Require Import Metarouting.IsoPres.Bisemigroups.Glue.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres : forall (x x' y y' : Bisemigroup), BSmgIso x x' -> BSmgIso y y' ->
      BSmgIso (prodBisemigroup x y) (prodBisemigroup x' y').
   Proof. intros x x' y y' i i';
      set (X := x); set (X' := x'); set (Y := y); set (Y' := y').
      
      apply Glue.isoPres.

      destruct x; destruct x'; destruct setoid; destruct setoid0;
      destruct y; destruct y'; destruct setoid; destruct setoid0; simpl in *.

      split with (IsoPres.Semigroups.Product.isoPres (plusSmg X) (plusSmg X') (plusSmg Y) (plusSmg Y')
                   (plusSmgBSmgIso i) (plusSmgBSmgIso i')).

      apply (isSmgIso
                  (IsoPres.Semigroups.Product.isoPres (timesSmg X) (timesSmg X') (timesSmg Y) (timesSmg Y')
                   (timesSmgBSmgIso i) (timesSmgBSmgIso i'))).
   Defined.

   Lemma idPres : forall (x x' y y' : Bisemigroup), IdBSmgIso x x' -> IdBSmgIso y y' ->
      IdBSmgIso (prodBisemigroup x y) (prodBisemigroup x' y').
   Proof.  intros x x' y y' i i'.
      split with (isoPres x x' y y' i i'); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct i' as [[[phi2 phi2']] [ip2 ip2']]; simpl in *;
      destruct x; destruct x'; destruct setoid; destruct setoid0;
      destruct y; destruct y'; destruct setoid; destruct setoid0; simpl in *.
      
      destruct ip1; destruct ip2; split; intros [x y]; simpl. rewrite (H x), (H0 y); auto.
      destruct ip1'; destruct ip2'; split; intros [x y]; simpl. rewrite (H x), (H0 y); auto.
   Defined.

End IsoPres.

