Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Constructions.Semigroups.Left.
Require Import Metarouting.Constructions.Bisemigroups.Left.
Require Import Metarouting.IsoPres.Semigroups.Left.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.
Require Import Coq.Lists.List.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : Semigroup), SmgIso x x' ->
      DsIso (leftBisemigroup x) (leftBisemigroup x').
   Proof. intros x x' i.
      set (X := x); set (X' := x'); 
      destruct x; destruct x'; destruct setoid; destruct setoid0.
      assert (p := IsoPres.Semigroups.Left.isoPres X X' i).
      simpl in *. apply p.
   Defined.

   Lemma isoPres : forall (x x' : Semigroup), SmgIso x x' ->
      BSmgIso (leftBisemigroup x) (leftBisemigroup x').
   Proof. intros x x' i. set (I := i).
      set (X := x); set (X' := x').
      split with (isoPres_helper x x' i).
      destruct x; destruct x'; destruct setoid; destruct setoid0;
      simpl in *; destruct i; split.
      
      intros x y; simpl in *; rewrite (pres_op isSmgIso); auto.
      intros x y; simpl in *; rewrite (pres_op' isSmgIso); auto.
      intros x y; simpl in *; unfold left_op; simpl; auto.
      intros x y; simpl in *; unfold left_op; simpl; auto.
   Defined.

   Lemma idPres : forall (x x' : Semigroup), IdSmgIso x x' ->
      IdBSmgIso (leftBisemigroup x) (leftBisemigroup x').
   Proof. intros x x' i.
      split with (isoPres x x' i); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *; auto.
   Defined.

End IsoPres.

