Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.DecSetoid.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.Bisemigroup.
Require Import Metarouting.Constructions.Bisemigroups.Unit.
Require Import Metarouting.Constructions.DecSetoids.Union.
Require Import Metarouting.Constructions.Bisemigroups.AddZero.
Require Import Metarouting.IsoPres.DecSetoids.Union.
Require Import Metarouting.Signatures.IdArrow.
Require Import Coq.Bool.Bool.

Section IsoPres.

   Lemma isoPres_helper : forall (x x' : Bisemigroup), BSmgIso x x' ->
      DsIso (addZeroBisemigroup x) (addZeroBisemigroup x').
   Proof. intros x x' i.
      apply (Union.isoPres (plusSmg x) (plusSmg x') unitBisemigroup unitBisemigroup i (DsIso_refl _)). 
   Defined.

   Lemma isoPres : forall (x x' : Bisemigroup), BSmgIso x x' ->
      BSmgIso (addZeroBisemigroup x) (addZeroBisemigroup x').
   Proof. intros x x' i. split with (isoPres_helper x x' i).
      destruct x; destruct x'; 
      destruct setoid; destruct setoid0; simpl in *; destruct i; split; simpl in *;
      intros [x|[]] [y|[]]; simpl; dseq_u; simpl; auto.
      
      apply (pres_plus isBSmgIso).
      apply (pres_plus' isBSmgIso).
      apply (pres_times isBSmgIso).
      apply (pres_times' isBSmgIso).
   Defined.

   Lemma idPres : forall (x x' : Bisemigroup), IdBSmgIso x x' ->
      IdBSmgIso (addZeroBisemigroup x) (addZeroBisemigroup x').
   Proof. intros x x' i; split with (isoPres x x' i); split;
      destruct i as [[[phi1 phi1']] [ip1 ip1']]; simpl in *;
      destruct x; destruct x'; destruct setoid; destruct setoid0; simpl in *; auto.
      
      clear -ip1; destruct ip1; split; simpl; intros [x|[]]; auto; rewrite (H x); auto.
      clear -ip1'; destruct ip1'; split; simpl; intros [x|[]]; auto; rewrite (H x); auto.
   Defined.

End IsoPres.
