Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.TransformPropRecord.
Require Import Metarouting.Constructions.Transforms.Product.
Require Import Metarouting.Inference.DecSetoids.Product.
Require Import Metarouting.Inference.Common.Common.

Definition prodTransform_props {a} {b} (ap : tfProp a) (bp : tfProp b) : tfProp (prodTransform a b).
   intros a b ap bp;
   apply (Build_tfProp (prodTransform a b) 
                       (prodDecSetoid_props ap bp)
                       (prodDecSetoid_props (tf_fndsprop _ ap) (tf_fndsprop _ bp)));
   hypPropSplit.
   
   (* Cancelative *)
   apply (opMap (@Product.cancelative a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.cancelative_comp a b)); opUnfoldBoolFormula; fail.

   (* Condensed *)
   apply (opMap (@Product.condensed a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.condensed_comp a b)); opUnfoldBoolFormula; fail.
Defined.
