Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Transform.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Signatures.TransformPropRecord.
Require Import Metarouting.Constructions.Transforms.Cayley.
Require Import Metarouting.Inference.Common.Common.

Definition cayleyMapTransform_props {a} (ap : sgProp a) : tfProp (cayleyMapTransform a).
   intros a ap;
   apply (Build_tfProp (cayleyMapTransform a) ap ap);
   hypPropSplit.
   
   (* Cancelative *)
   apply (opMap (@Cayley.cancelative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Cayley.cancelative_comp a)); opUnfoldBoolFormula; fail.

   (* Condensed *)
   apply (opMap (@Cayley.condensed a)); opUnfoldBoolFormula; fail.
   apply (opMap (@Cayley.condensed_comp a)); opUnfoldBoolFormula; fail.
Defined.
