Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.Unit.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Unit.

Definition unitSemigroup_props : sgProp unitSemigroup.
   apply Build_sgProp.
   apply unitDecSetoid_props.
   
   (* HasIdentity *)
   apply (opInit Unit.hasIdentity).
   apply None.

   (* HasAnnihilator *)
   apply (opInit Unit.hasAnnihilator).
   apply None.

   (* IsSelective *)
   apply (opInit Unit.isSelective).
   apply None.

   (* IsCommutative *)
   apply (opInit Unit.isCommutative).
   apply None.

   (* IsIdempotent *)
   apply (opInit Unit.isIdempotent).
   apply None.

   (* IsLeft *)
   apply (opInit Unit.isLeft).
   apply None.

   (* IsRight *)
   apply (opInit Unit.isRight).
   apply None.

   (* LeftCondensed *)
   apply (opInit Unit.leftCondensed).
   apply None.

   (* RightCondensed *)
   apply (opInit Unit.rightCondensed).
   apply None.

   (* LeftCancelative *)
   apply (opInit Unit.leftCancelative).
   apply None.

   (* RightCancelative *)
   apply (opInit Unit.rightCancelative).
   apply None.

   (* AntiLeft *)
   apply None.
   apply (opInit Unit.antiLeft_comp).

   (* AntiRight *)
   apply None.
   apply (opInit Unit.antiRight_comp).
   
   (* TreeGlb *)
   apply (opInit Unit.treeGlb).
   apply None.
   
Defined.
