Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.Union.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Union.

Definition unionSemigroup_props {a} {b} (ap : sgProp a) (bp : sgProp b) : sgProp (unionSemigroup a b).
   intros a b ap bp;
   apply (Build_sgProp (unionSemigroup a b) (unionDecSetoid_props ap bp));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opMap (@Union.hasIdentity a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Union.hasIdentity_comp a b)); opUnfoldBoolFormula; fail.

   (* HasAnnihilator *)
   apply (opMap (@Union.hasAnnihilator a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Union.hasAnnihilator_comp a b)); opUnfoldBoolFormula; fail.

   (* IsSelective *)
   apply (opMap (@Union.isSelective a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Union.isSelective_comp a b)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opMap (@Union.isCommutative a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Union.isCommutative_comp a b)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply (opMap (@Union.isIdempotent a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Union.isIdempotent_comp a b)); opUnfoldBoolFormula; fail.

   (* IsLeft *)
   apply None.
   apply (opInit (@Union.isLeft_comp a b)).

   (* IsRight *)
   apply None.
   apply (opInit (@Union.isRight_comp a b)).

   (* LeftCondensed *)
   apply None.
   apply (opInit (@Union.leftCondensed_comp a b)).

   (* RightCondensed *)
   apply None.
   apply (opInit (@Union.rightCondensed_comp a b)).

   (* LeftCancelative *)
   apply (opMap (@Union.leftCancelative a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Union.leftCancelative_comp a b)); opUnfoldBoolFormula; fail.

   (* RightCancelative *)
   apply (opMap (@Union.rightCancelative a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Union.rightCancelative_comp a b)); opUnfoldBoolFormula; fail.

   (* AntiLeft *)
   apply None.
   apply (opInit (@Union.antiLeft_comp a b)).

   (* AntiRight *)
   apply None.
   apply (opInit (@Union.antiRight_comp a b)).

   (* RightCancelative *)
   apply (opMap (@Union.treeGlb a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Union.treeGlb_comp a b)); opUnfoldBoolFormula; fail.
Defined.
