Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.RevOp.
Require Import Metarouting.Inference.Common.Common.

Definition revOpSemigroup_props {a} (ap : sgProp a) : sgProp (revOpSemigroup a).
   intros a ap;
   apply (Build_sgProp (revOpSemigroup a) ap);
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opMap (@RevOp.hasIdentity a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.hasIdentity_comp a)); opUnfoldBoolFormula; fail.

   (* HasAnnihilator *)
   apply (opMap (@RevOp.hasAnnihilator a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.hasAnnihilator_comp a)); opUnfoldBoolFormula; fail.

   (* IsSelective *)
   apply (opMap (@RevOp.isSelective a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.isSelective_comp a)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opMap (@RevOp.isCommutative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.isCommutative_comp a)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply (opMap (@RevOp.isIdempotent a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.isIdempotent_comp a)); opUnfoldBoolFormula; fail.

   (* IsLeft *)
   apply (opMap (@RevOp.isLeft a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.isLeft_comp a)); opUnfoldBoolFormula; fail.

   (* IsRight *)
   apply (opMap (@RevOp.isRight a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.isRight_comp a)); opUnfoldBoolFormula; fail.

   (* LeftCondensed *)
   apply (opMap (@RevOp.leftCondensed a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.leftCondensed_comp a)); opUnfoldBoolFormula; fail.

   (* RightCondensed *)
   apply (opMap (@RevOp.rightCondensed a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.rightCondensed_comp a)); opUnfoldBoolFormula; fail.

   (* LeftCancelative *)
   apply (opMap (@RevOp.leftCancelative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.leftCancelative_comp a)); opUnfoldBoolFormula; fail.

   (* RightCancelative *)
   apply (opMap (@RevOp.rightCancelative a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.rightCancelative_comp a)); opUnfoldBoolFormula; fail.

   (* AntiLeft *)
   apply (opMap (@RevOp.antiLeft a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.antiLeft_comp a)); opUnfoldBoolFormula; fail.

   (* AntiRight *)
   apply (opMap (@RevOp.antiRight a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.antiRight_comp a)); opUnfoldBoolFormula; fail.

   (* TreeGlb *)
   apply (opMap (@RevOp.treeGlb a)); opUnfoldBoolFormula; fail.
   apply (opMap (@RevOp.treeGlb_comp a)); opUnfoldBoolFormula; fail.
Defined.
