Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.RangePlus.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Range.
Require Import Metarouting.Inference.Semigroups.Unit.
Require Import Metarouting.Inference.Semigroups.BoolOr.

Definition rangePlusSemigroup_props n : sgProp (rangePlusSemigroup n).
   intros [|[|n]].
   apply (sgPropIso (SmgIso_sym rplus0SmgIso) unitSemigroup_props).
   apply (sgPropIso (SmgIso_sym rplus1SmgIso) boolOrSemigroup_props).
   apply Build_sgProp.
   apply (rangeDecSetoid_props (S (S n))).
   
   (* HasIdentity *)
   apply (opInit (RangePlus.hasIdentity (S (S n)))).
   apply None.

   (* HasAnnihilator *)
   apply (opInit (RangePlus.hasAnnihilator (S (S n)))).
   apply None.

   (* IsSelective *)
   apply None.
   apply (opInit (RangePlus.isSelective_comp n)).

   (* IsCommutative *)
   apply (opInit (RangePlus.isCommutative (S (S n)))).
   apply None.

   (* IsIdempotent *)
   apply None.
   apply (opInit (RangePlus.isIdempotent_comp n)).

   (* IsLeft *)
   apply None.
   apply (opInit (RangePlus.isLeft_comp (S n))).

   (* IsRight *)
   apply None.
   apply (opInit (RangePlus.isRight_comp (S n))).

   (* LeftCondensed *)
   apply None.
   apply (opInit (RangePlus.leftCondensed_comp (S n))).

   (* RightCondensed *)
   apply None.
   apply (opInit (RangePlus.rightCondensed_comp (S n))).

   (* LeftCancelative *)
   apply None.
   apply (opInit (RangePlus.leftCancelative_comp (S n))).

   (* RightCancelative *)
   apply None.
   apply (opInit (RangePlus.rightCancelative_comp (S n))).

   (* AntiLeft *)
   apply None.
   apply (opInit (RangePlus.antiLeft_comp (2 + n))).

   (* AntiRight *)
   apply None.
   apply (opInit (RangePlus.antiRight_comp (2 + n))).

   (* TreeGlb *)
   apply None.
   apply (opInit (RangePlus.treeGlb_comp n)).
Defined.
