Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.RangeMin.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Range.
Require Import Metarouting.Inference.Semigroups.Unit.
Require Import Metarouting.Inference.Semigroups.BoolAnd.

Definition rangeMinSemigroup_props n : sgProp (rangeMinSemigroup n).
   intros [|[|n]].
   apply (sgPropIso (SmgIso_sym rmin0SmgIso) unitSemigroup_props).
   apply (sgPropIso (SmgIso_sym rmin1SmgIso) boolAndSemigroup_props).
   apply Build_sgProp.
   apply (rangeDecSetoid_props (S (S n))).
   
   (* HasIdentity *)
   apply (opInit (RangeMin.hasIdentity (S (S n)))).
   apply None.

   (* HasAnnihilator *)
   apply (opInit (RangeMin.hasAnnihilator (S (S n)))).
   apply None.

   (* IsSelective *)
   apply (opInit (RangeMin.isSelective (S (S n)))).
   apply None.

   (* IsCommutative *)
   apply (opInit (RangeMin.isCommutative (S (S n)))).
   apply None.

   (* IsIdempotent *)
   apply (opInit (RangeMin.isIdempotent (S (S n)))).
   apply None.

   (* IsLeft *)
   apply None.
   apply (opInit (RangeMin.isLeft_comp (S n))).

   (* IsRight *)
   apply None.
   apply (opInit (RangeMin.isRight_comp (S n))).

   (* LeftCondensed *)
   apply None.
   apply (opInit (RangeMin.leftCondensed_comp (S n))).

   (* RightCondensed *)
   apply None.
   apply (opInit (RangeMin.rightCondensed_comp (S n))).

   (* LeftCancelative *)
   apply None.
   apply (opInit (RangeMin.leftCancelative_comp (S n))).

   (* RightCancelative *)
   apply None.
   apply (opInit (RangeMin.rightCancelative_comp (S n))).

   (* AntiLeft *)
   apply None.
   apply (opInit (RangeMin.antiLeft_comp (2 + n))).

   (* AntiRight *)
   apply None.
   apply (opInit (RangeMin.antiRight_comp (2 + n))).

   (* TreeGlb *)
   apply (opInit (RangeMin.treeGlb (2 + n))).
   apply None.
Defined.
