Require Import Metarouting.Logic.Logic.
Require Import Metarouting.Signatures.Semigroup.
Require Import Metarouting.Signatures.SemigroupPropRecord.
Require Import Metarouting.Constructions.Semigroups.Product.
Require Import Metarouting.Inference.Common.Common.
Require Import Metarouting.Inference.DecSetoids.Product.

Definition prodSemigroup_props {a} {b} (ap : sgProp a) (bp : sgProp b) : sgProp (prodSemigroup a b).
   intros a b ap bp;
   apply (Build_sgProp (prodSemigroup a b) (prodDecSetoid_props ap bp));
   hypPropSplit.
   
   (* HasIdentity *)
   apply (opMap (@Product.hasIdentity a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.hasIdentity_comp a b)); opUnfoldBoolFormula; fail.

   (* HasAnnihilator *)
   apply (opMap (@Product.hasAnnihilator a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.hasAnnihilator_comp a b)); opUnfoldBoolFormula; fail.

   (* IsSelective *)
   apply (opMap (@Product.isSelective a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isSelective_comp a b)); opUnfoldBoolFormula; fail.

   (* IsCommutative *)
   apply (opMap (@Product.isCommutative a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isCommutative_comp a b)); opUnfoldBoolFormula; fail.

   (* IsIdempotent *)
   apply (opMap (@Product.isIdempotent a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isIdempotent_comp a b)); opUnfoldBoolFormula; fail.

   (* IsLeft *)
   apply (opMap (@Product.isLeft a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isLeft_comp a b)); opUnfoldBoolFormula; fail.

   (* IsRight *)
   apply (opMap (@Product.isRight a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.isRight_comp a b)); opUnfoldBoolFormula; fail.

   (* LeftCondensed *)
   apply (opMap (@Product.leftCondensed a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.leftCondensed_comp a b)); opUnfoldBoolFormula; fail.

   (* RightCondensed *)
   apply (opMap (@Product.rightCondensed a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.rightCondensed_comp a b)); opUnfoldBoolFormula; fail.

   (* LeftCancelative *)
   apply (opMap (@Product.leftCancelative a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.leftCancelative_comp a b)); opUnfoldBoolFormula; fail.

   (* RightCancelative *)
   apply (opMap (@Product.rightCancelative a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.rightCancelative_comp a b)); opUnfoldBoolFormula; fail.

   (* AntiLeft *)
   apply (opMap (@Product.antiLeft a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.antiLeft_comp a b)); opUnfoldBoolFormula; fail.

   (* AntiRight *)
   apply (opMap (@Product.antiRight a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.antiRight_comp a b)); opUnfoldBoolFormula; fail.

   (* TreeGlb *)
   apply (opMap (@Product.treeGlb a b)); opUnfoldBoolFormula; fail.
   apply (opMap (@Product.treeGlb_comp a b)); opUnfoldBoolFormula; fail.
Defined.
